/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.pagesetup.PageSetupPageType;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class PageInfoHelper {
    private static final Map pageSizes = new HashMap();

    static {
        pageSizes.put(PageSetupPageType.LETTER, new Point2D.Double(8.5, 11.0));
        pageSizes.put(PageSetupPageType.LEGAL, new Point2D.Double(8.5, 14.0));
        pageSizes.put(PageSetupPageType.EXECUTIVE, new Point2D.Double(7.25, 10.5));
        pageSizes.put(PageSetupPageType.llX17, new Point2D.Double(11.0, 17.0));
        pageSizes.put(PageSetupPageType.A3, new Point2D.Double(11.69, 16.54));
        pageSizes.put(PageSetupPageType.A4, new Point2D.Double(8.268, 11.69));
        pageSizes.put(PageSetupPageType.B4, new Point2D.Double(14.33, 10.12));
        pageSizes.put(PageSetupPageType.B5, new Point2D.Double(7.165, 10.12));
    }

    public static Rectangle getChildrenBounds(DiagramEditPart diagramEditPart, Class pageBreakClass) {
        Rectangle diagramRec = null;
        Point location = new Point();
        IFigure f = diagramEditPart.getContentPane();
        List list = f.getChildren();
        if (Collections.EMPTY_LIST == list) {
            return new Rectangle();
        }
        boolean init = true;
        int i = 0;
        while (i < list.size()) {
            Figure childFigure = (Figure)list.get(i);
            if (pageBreakClass == null || !pageBreakClass.isInstance(childFigure)) {
                Rectangle r = null;
                Point childLocation = null;
                if (childFigure instanceof IExpandableFigure) {
                    r = ((IExpandableFigure)childFigure).getExtendedBounds();
                    childLocation = r.getLocation();
                } else {
                    r = childFigure.getBounds();
                    childLocation = childFigure.getLocation();
                }
                if (init) {
                    location.x = childLocation.x;
                    location.y = childLocation.y;
                    diagramRec = r;
                    init = false;
                }
                diagramRec = diagramRec.getUnion(r);
                if (childLocation.x < location.x) {
                    location.x = childLocation.x;
                }
                if (childLocation.y < location.y) {
                    location.y = childLocation.y;
                }
            }
            ++i;
        }
        if (diagramRec == null) {
            return new Rectangle();
        }
        diagramRec.x = location.x;
        diagramRec.y = location.y;
        return diagramRec;
    }

    public static Point getPageSize(IPreferenceStore store, IMapMode mm) {
        return PageInfoHelper.getPageSize(store, true, mm);
    }

    public static Point getPageSize(IPreferenceStore store, boolean subtractMargins, IMapMode mm) {
        double paperSizeWidth = store.getDouble("print.page.width");
        double paperSizeHeight = store.getDouble("print.page.height");
        double leftMargin = store.getDouble("print.margin.left");
        double topMargin = store.getDouble("print.margin.top");
        double bottomMargin = store.getDouble("print.margin.bottom");
        double rightMargin = store.getDouble("print.margin.right");
        if (store.getBoolean("print.useLandscape")) {
            double temp = paperSizeWidth;
            paperSizeWidth = paperSizeHeight;
            paperSizeHeight = temp;
        }
        double width = paperSizeWidth;
        double height = paperSizeHeight;
        if (subtractMargins) {
            width -= leftMargin + rightMargin;
            height -= topMargin + bottomMargin;
        }
        int[] paperSize = new int[2];
        Display display = DisplayUtils.getDisplay();
        org.eclipse.swt.graphics.Point displayDPI = display.getDPI();
        paperSize[0] = mm.DPtoLP((int)(width * (double)displayDPI.x));
        paperSize[1] = mm.DPtoLP((int)(height * (double)displayDPI.y));
        return new Point(paperSize[0], paperSize[1]);
    }

    public static String getPrinterPageType() {
        String pageType = PageSetupPageType.LETTER.getName();
        Printer printer = null;
        try {
            printer = new Printer();
        }
        catch (SWTError e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, PageInfoHelper.class, (String)"getPrinterPage", (Throwable)e);
            if (e.code == 2) {
                return pageType;
            }
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)6, (String)"Failed to make instance of Printer object", (Throwable)e);
            Trace.throwing((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, PageInfoHelper.class, (String)"getPrinterPage", (Throwable)e);
            throw e;
        }
        org.eclipse.swt.graphics.Rectangle physicalSize = printer.getBounds();
        org.eclipse.swt.graphics.Point dpi = printer.getDPI();
        Point2D.Double size = new Point2D.Double(physicalSize.width / dpi.x, physicalSize.height / dpi.y);
        Map pageTypes = PageInfoHelper.getPaperSizesMap();
        Set pageTypeEntrySet = pageTypes.entrySet();
        boolean first = true;
        double bestFit = 0.0;
        for (Map.Entry pageTypeEntry : pageTypeEntrySet) {
            String thisPageType = (String)pageTypeEntry.getKey();
            Point2D.Double thisSize = (Point2D.Double)pageTypeEntry.getValue();
            if (first) {
                bestFit = size.distance(thisSize);
                pageType = thisPageType;
                first = false;
                continue;
            }
            double thisFit = size.distance(thisSize);
            if (!(thisFit < bestFit)) continue;
            bestFit = thisFit;
            pageType = thisPageType;
        }
        printer.dispose();
        return pageType;
    }

    public static final Map getPaperSizesMap() {
        return pageSizes;
    }

    public static PageMargins getPageMargins(IPreferenceStore preferenceStore, IMapMode mm) {
        org.eclipse.swt.graphics.Point displayDPI = DisplayUtils.getDisplay().getDPI();
        PageMargins margins = new PageMargins();
        margins.left = mm.DPtoLP((int)((double)displayDPI.x * preferenceStore.getDouble("print.margin.left")));
        margins.right = mm.DPtoLP((int)((double)displayDPI.x * preferenceStore.getDouble("print.margin.right")));
        margins.top = mm.DPtoLP((int)((double)displayDPI.y * preferenceStore.getDouble("print.margin.top")));
        margins.bottom = mm.DPtoLP((int)((double)displayDPI.y * preferenceStore.getDouble("print.margin.bottom")));
        return margins;
    }

    public static final class PageMargins {
        public int left;
        public int right;
        public int top;
        public int bottom;
    }
}

