/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Messages;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class BridgeException
extends RuntimeException {
    protected Element e;
    protected String code;
    protected Object[] params;
    protected int line;
    protected GraphicsNode node;

    public BridgeException(Element element, String string, Object[] objectArray) {
        this.e = element;
        this.code = string;
        this.params = objectArray;
    }

    public Element getElement() {
        return this.e;
    }

    public void setLineNumber(int n) {
        this.line = n;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        this.node = graphicsNode;
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public String getMessage() {
        String string = "<Unknown Element>";
        SVGDocument sVGDocument = null;
        if (this.e != null) {
            sVGDocument = (SVGDocument)this.e.getOwnerDocument();
            string = this.e.getLocalName();
        }
        String string2 = sVGDocument == null ? "<Unknown Document>" : sVGDocument.getURL();
        Object[] objectArray = new Object[this.params.length + 3];
        objectArray[0] = string2;
        objectArray[1] = new Integer(this.line);
        objectArray[2] = string;
        int n = 0;
        while (n < this.params.length) {
            objectArray[n + 3] = this.params[n];
            ++n;
        }
        return Messages.formatMessage(this.code, objectArray);
    }

    public String getCode() {
        return this.code;
    }
}

