/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.emf.clipboard.core.BasePasteOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteTarget;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.IClipboardSupport2;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.PasteIntoParentOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ResourceInfoProcessor;

public class PasteOperation
extends BasePasteOperation {
    private Map parentPasteRecordMap;
    private PasteTarget parent;
    private Map hintsMap;

    public PasteOperation(IProgressMonitor monitor, IClipboardSupport clipboardSupport, String string, PasteTarget parent, Map loadOptionsMap, Map hintsMap) throws Exception {
        super(monitor, loadOptionsMap, ResourceInfoProcessor.getResourceInfo(string), clipboardSupport);
        this.hintsMap = hintsMap == null ? Collections.EMPTY_MAP : hintsMap;
        this.parentPasteRecordMap = new HashMap();
        this.parent = parent;
    }

    private final PasteIntoParentOperation getParentPasteProcess(PasteTarget parentElement) throws Exception {
        PasteIntoParentOperation parentPasteProcess = (PasteIntoParentOperation)this.parentPasteRecordMap.get(parentElement);
        if (parentPasteProcess == null) {
            IClipboardSupport helper = this.getClipboardOperationHelper();
            if (helper instanceof IClipboardSupport2 && ((IClipboardSupport2)((Object)helper)).shouldOverridePasteIntoParentOperation(parentElement, this.getHintsMap())) {
                parentPasteProcess = ((IClipboardSupport2)((Object)helper)).getPasteIntoParentOperation(this, parentElement, this.getHintsMap());
            }
            if (parentPasteProcess == null) {
                parentPasteProcess = new PasteIntoParentOperation(this, parentElement, this.getHintsMap());
            }
            this.parentPasteRecordMap.put(parentElement, parentPasteProcess);
        }
        return parentPasteProcess;
    }

    public void paste() throws Exception {
        this.getProgressMonitor().worked(1);
        if (this.isCancelled()) {
            this.throwCancelException();
        }
        PasteIntoParentOperation parentPasteProcess = this.getParentPasteProcess(this.parent);
        if (this.isCancelled()) {
            this.throwCancelException();
        }
        parentPasteProcess.paste();
        if (!this.getCriticalResolveFailuresSet().isEmpty()) {
            this.throwException("paste", new IllegalStateException("Critical Resolve Failure While Pasting"));
        }
    }

    public BasePasteOperation getSpawningPasteOperation() {
        return null;
    }

    public Map getHintsMap() {
        return this.hintsMap;
    }
}

