/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class Property<T> {
    private final String name;
    private final Type type;
    private final Class<T> rawType;

    protected Property(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalStateException("Missing type parameter");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        this.type = parameterized.getActualTypeArguments()[0];
        Class<?> rawType = Property.toClass(this.type);
        if (rawType == null) {
            throw new IllegalStateException("Unsupported type parameter");
        }
        this.rawType = rawType;
    }

    private Property(String name, Type type, Class<T> rawType) {
        this.name = name;
        this.type = type;
        this.rawType = rawType;
    }

    public static <T> Property<T> get(String name, Class<T> type) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return new Property<T>(name, type, type);
    }

    public Property<T> withDefault(T defaultValue) {
        return new WithDefault<T>(this.name, this.type, this.rawType, defaultValue);
    }

    public final String getName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<T> getRawType() {
        return this.rawType;
    }

    public T defaultValue() {
        return null;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf(this.name) + " : " + this.type.getTypeName();
    }

    private static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Property.toClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(Property.toClass(componentType), 0).getClass();
        }
        return null;
    }

    private static final class WithDefault<T>
    extends Property<T> {
        private final T defaultValue;

        WithDefault(String name, Type type, Class<T> rawType, T defaultValue) {
            super(name, type, rawType);
            this.defaultValue = defaultValue;
        }

        @Override
        public T defaultValue() {
            return this.defaultValue;
        }
    }
}

