/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

public final class TextRange {
    private final int offset;
    private final int length;

    public TextRange(int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        this.length = length;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getEndOffset() {
        return this.offset + this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean strictlyCovers(int position) {
        return position >= this.offset && position < this.offset + this.length;
    }

    public boolean covers(int position) {
        return position >= this.offset && position <= this.offset + this.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextRange other = (TextRange)obj;
        if (this.length != other.length) {
            return false;
        }
        return this.offset == other.offset;
    }

    public String toString() {
        return "[offset=" + this.offset + ", length=" + this.length + "]";
    }
}

