/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.handly.util.UiSynchronizer;

public final class SimpleSynchronizer
extends UiSynchronizer {
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
        this.thread = new Thread(r);
        return this.thread;
    });
    private Thread thread;

    public SimpleSynchronizer() {
        this.executor.prestartCoreThread();
    }

    public void dispose() {
        this.executor.shutdownNow();
    }

    public Thread getThread() {
        return this.thread;
    }

    public void asyncExec(Runnable runnable) {
        this.executor.submit(runnable);
    }

    public void syncExec(Runnable runnable) throws ExecutionException {
        try {
            this.executor.submit(runnable).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

