/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.ListConfigurationsExtendedResult;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ListConfigurationsExtendedRequest
extends ExtendedRequest {
    public static final String LIST_CONFIGS_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.26";
    private static final long serialVersionUID = -5511054471842622735L;

    public ListConfigurationsExtendedRequest(Control ... controls) {
        super(LIST_CONFIGS_REQUEST_OID, controls);
    }

    public ListConfigurationsExtendedRequest(ExtendedRequest r) throws LDAPException {
        super(r);
        if (r.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_LIST_CONFIGS_REQUEST_HAS_VALUE.get());
        }
    }

    @Override
    public ListConfigurationsExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new ListConfigurationsExtendedResult(extendedResponse);
    }

    @Override
    public ListConfigurationsExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public ListConfigurationsExtendedRequest duplicate(Control[] controls) {
        ListConfigurationsExtendedRequest r = new ListConfigurationsExtendedRequest(controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_LIST_CONFIGS.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ListConfigurationsExtendedRequest(");
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

