/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.net.Authenticator;
import java.net.CookieManager;
import java.net.ProxySelector;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.internal.common.Utils;

class HttpClientBuilderImpl
extends HttpClient.Builder {
    CookieManager cookieManager;
    HttpClient.Redirect followRedirects;
    ProxySelector proxy;
    Authenticator authenticator;
    HttpClient.Version version;
    Executor executor;
    SSLContext sslContext;
    SSLParameters sslParams;
    int priority = -1;

    HttpClientBuilderImpl() {
    }

    @Override
    public HttpClientBuilderImpl cookieManager(CookieManager cookieManager) {
        Objects.requireNonNull(cookieManager);
        this.cookieManager = cookieManager;
        return this;
    }

    @Override
    public HttpClientBuilderImpl sslContext(SSLContext sSLContext) {
        Objects.requireNonNull(sSLContext);
        Utils.checkNetPermission("setSSLContext");
        this.sslContext = sSLContext;
        return this;
    }

    @Override
    public HttpClientBuilderImpl sslParameters(SSLParameters sSLParameters) {
        Objects.requireNonNull(sSLParameters);
        this.sslParams = sSLParameters;
        return this;
    }

    @Override
    public HttpClientBuilderImpl executor(Executor executor) {
        Objects.requireNonNull(executor);
        this.executor = executor;
        return this;
    }

    @Override
    public HttpClientBuilderImpl followRedirects(HttpClient.Redirect redirect) {
        Objects.requireNonNull(redirect);
        this.followRedirects = redirect;
        return this;
    }

    @Override
    public HttpClientBuilderImpl version(HttpClient.Version version) {
        Objects.requireNonNull(version);
        this.version = version;
        return this;
    }

    @Override
    public HttpClientBuilderImpl priority(int n) {
        if (n < 1 || n > 256) {
            throw new IllegalArgumentException("priority must be between 1 and 256");
        }
        this.priority = n;
        return this;
    }

    @Override
    public HttpClientBuilderImpl proxy(ProxySelector proxySelector) {
        Objects.requireNonNull(proxySelector);
        this.proxy = proxySelector;
        return this;
    }

    @Override
    public HttpClientBuilderImpl authenticator(Authenticator authenticator) {
        Objects.requireNonNull(authenticator);
        this.authenticator = authenticator;
        return this;
    }

    @Override
    public HttpClient build() {
        return HttpClientImpl.create(this);
    }
}

