/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import jdk.incubator.http.internal.hpack.BinaryRepresentationWriter;
import jdk.incubator.http.internal.hpack.HeaderTable;
import jdk.incubator.http.internal.hpack.SizeUpdateWriter;

final class BulkSizeUpdateWriter
implements BinaryRepresentationWriter {
    private final SizeUpdateWriter writer = new SizeUpdateWriter();
    private Iterator<Integer> maxSizes;
    private boolean writing;
    private boolean configured;

    BulkSizeUpdateWriter() {
    }

    BulkSizeUpdateWriter maxHeaderTableSizes(Iterable<Integer> iterable) {
        if (this.configured) {
            throw new IllegalStateException("Already configured");
        }
        Objects.requireNonNull(iterable, "sizes");
        this.maxSizes = iterable.iterator();
        this.configured = true;
        return this;
    }

    @Override
    public boolean write(HeaderTable headerTable, ByteBuffer byteBuffer) {
        if (!this.configured) {
            throw new IllegalStateException("Configure first");
        }
        while (true) {
            if (this.writing) {
                if (!this.writer.write(headerTable, byteBuffer)) {
                    return false;
                }
                this.writing = false;
                continue;
            }
            if (!this.maxSizes.hasNext()) break;
            this.writing = true;
            this.writer.reset();
            this.writer.maxHeaderTableSize(this.maxSizes.next());
        }
        this.configured = false;
        return true;
    }

    @Override
    public BulkSizeUpdateWriter reset() {
        this.maxSizes = null;
        this.writing = false;
        this.configured = false;
        return this;
    }
}

