/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MethodDescr;
import java.util.HashMap;
import java.util.Map;

class MethodOverridingChecker {
    private final Map<String, MethodDescr> methodSignatures = new HashMap<String, MethodDescr>();
    private final Erasurator erasurator;

    public MethodOverridingChecker(Erasurator er) {
        this.erasurator = er;
    }

    public void addMethod(MethodDescr m) {
        MethodDescr cloned_m = (MethodDescr)this.erasurator.processMember(m);
        assert (!cloned_m.getSignature().contains("%")) : "wrong member after erasure: " + m;
        this.methodSignatures.put(cloned_m.getSignature(), cloned_m);
    }

    public MethodDescr getOverridingMethod(MethodDescr m, boolean autoAdd) {
        MethodDescr cloned_m = (MethodDescr)this.erasurator.processMember(m);
        String signature = cloned_m.getSignature();
        MethodDescr isOverriding = this.methodSignatures.get(signature);
        if (isOverriding == null && autoAdd) {
            this.methodSignatures.put(signature, cloned_m);
        }
        return isOverriding;
    }

    public void addMethods(MemberDescription[] methods, String name) {
        for (MemberDescription method : methods) {
            MethodDescr md = (MethodDescr)method;
            if (!name.equals(md.getName())) continue;
            this.addMethod(md);
        }
    }

    public void addMethods(MemberDescription[] methods) {
        for (MemberDescription method : methods) {
            MethodDescr md = (MethodDescr)method;
            this.addMethod(md);
        }
    }
}

