/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.application.context;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.mvc.Controller;
import jakarta.mvc.Models;
import jakarta.mvc.MvcContext;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.lang.annotation.Annotation;
import java.util.Set;

@Controller
@Path(value="application/context")
public class MvcContextController {
    @Inject
    private MvcContext context;
    @Inject
    private Models models;
    @Inject
    private BeanManager beanManager;

    @GET
    public String render() {
        this.models.put("mvcContextInjected", (Object)(this.context != null ? 1 : 0));
        this.models.put("csrfAccessible", (Object)(this.context != null && this.context.getCsrf() != null ? 1 : 0));
        this.models.put("pathAccessible", (Object)(this.context != null && this.context.getBasePath() != null ? 1 : 0));
        this.models.put("configAccessible", (Object)(this.context != null && this.context.getConfig() != null ? 1 : 0));
        this.models.put("encodersAccessible", (Object)(this.context != null && this.context.getEncoders() != null ? 1 : 0));
        this.models.put("mvcContextScope", MvcContextController.getScopeName(this.beanManager, MvcContext.class));
        return "application/context/result.jsp";
    }

    private static Object getScopeName(BeanManager beanManager, Class<?> type) {
        Set beans = beanManager.getBeans(type, new Annotation[0]);
        if (beans.size() == 1) {
            return ((Bean)beans.iterator().next()).getScope().getName();
        }
        return null;
    }
}

