/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.i18n.standard;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import jakarta.mvc.tck.tests.i18n.standard.I18nStandardController;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class I18nStandardTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(I18nStandardController.class).addView("i18n/standard/view.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_default_resolver", id="default-locale-resolver")})
    public void singleLocaleInAcceptLanguageHeader() throws IOException {
        WebRequest request = new WebRequest(new URL(this.baseUrl.toString() + "mvc/i18n/standard"));
        request.setAdditionalHeader("Accept-Language", "es");
        WebResponse response = this.webClient.getPage(request).getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Language = [es]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_default_resolver", id="default-locale-resolver")})
    public void multipleLocalesInAcceptLanguageHeader() throws IOException {
        WebRequest request = new WebRequest(new URL(this.baseUrl.toString() + "mvc/i18n/standard"));
        request.setAdditionalHeader("Accept-Language", "es;q=0.5,fr;q=0.9");
        WebResponse response = this.webClient.getPage(request).getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Language = [fr]"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="i18n_default_resolver", id="default-locale-resolver")})
    public void missingAcceptLanguageHeader() throws IOException {
        WebRequest request = new WebRequest(new URL(this.baseUrl.toString() + "mvc/i18n/standard"));
        request.removeAdditionalHeader("Accept-Language");
        WebResponse response = this.webClient.getPage(request).getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Language = [en]"));
    }
}

