/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mvc.tck.tests.mvc.controller.inject;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import jakarta.mvc.tck.tests.mvc.controller.inject.InjectParamsController;
import jakarta.mvc.tck.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class InjectParamsTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(InjectParamsController.class).addView("Value = '${value}'", "view.jsp").build();
    }

    @Test
    @SpecAssertion(section="controllers", id="inject-param-types")
    public void injectPathParam() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/inject/path/foobar").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value = 'foobar'"));
    }

    @Test
    @SpecAssertion(section="controllers", id="inject-param-types")
    public void injectQueryParam() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/inject/query?value=FOOBAR").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value = 'FOOBAR'"));
    }

    @Test
    @SpecAssertion(section="controllers", id="inject-param-types")
    public void injectHeaderParam() throws IOException {
        WebRequest request = new WebRequest(UrlUtils.toUrlUnsafe((String)(this.baseUrl.toString() + "mvc/inject/header")));
        request.setAdditionalHeader("X-Value", "FooBar");
        WebResponse response = new WebClient().getPage(request).getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value = 'FooBar'"));
    }

    @Test
    @SpecAssertion(section="controllers", id="inject-field-props")
    public void injectFieldParam() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/inject/field?fieldValue=foo-bar").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value = 'foo-bar'"));
    }

    @Test
    @SpecAssertion(section="controllers", id="inject-field-props")
    public void injectPropertyParam() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/inject/property?propertyValue=foo-BAR").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Value = 'foo-BAR'"));
    }
}

