/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.ArquillianTest;
import org.jboss.arquillian.junit.ArquillianTestClass;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.TestClass;

public class State {
    private static ThreadLocal<Throwable> caughtTestException = new ThreadLocal();
    private static ThreadLocal<Throwable> caughtExceptionAfterJunit = new ThreadLocal();
    private static ThreadLocal<Throwable> caughtInitializationException = new ThreadLocal();
    private static ThreadLocal<Integer> lastCreatedRunner = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Integer(0);
        }
    };
    private static boolean runningInEclipse = false;
    private static ThreadLocal<TestRunnerAdaptor> deployableTest = new ThreadLocal();

    public static boolean isRunningInEclipse() {
        return runningInEclipse;
    }

    public static boolean isNotRunningInEclipse() {
        return !runningInEclipse;
    }

    static void runnerStarted() {
        lastCreatedRunner.set(lastCreatedRunner.get() + 1);
    }

    static boolean hasAnyArquillianRule(TestClass testClass) {
        for (FrameworkField field : testClass.getAnnotatedFields()) {
            if (!ArquillianTestClass.class.equals((Object)field.getType()) && !ArquillianTest.class.equals((Object)field.getType())) continue;
            return true;
        }
        return false;
    }

    static Integer runnerFinished() {
        Integer currentCount = lastCreatedRunner.get() - 1;
        lastCreatedRunner.set(currentCount);
        return currentCount;
    }

    static Integer runnerCurrent() {
        return lastCreatedRunner.get();
    }

    static boolean isLastRunner() {
        return State.runnerCurrent() == 0;
    }

    static void testAdaptor(TestRunnerAdaptor adaptor) {
        deployableTest.set(adaptor);
    }

    static boolean hasTestAdaptor() {
        return State.getTestAdaptor() != null;
    }

    static TestRunnerAdaptor getTestAdaptor() {
        return deployableTest.get();
    }

    static void caughtInitializationException(Throwable throwable) {
        caughtInitializationException.set(throwable);
    }

    static boolean hasInitializationException() {
        return State.getInitializationException() != null;
    }

    static Throwable getInitializationException() {
        return caughtInitializationException.get();
    }

    public static void caughtTestException(Throwable throwable) {
        if (throwable == null) {
            caughtTestException.remove();
        } else {
            caughtTestException.set(throwable);
        }
    }

    public static boolean hasTestException() {
        return State.getTestException() != null;
    }

    public static Throwable getTestException() {
        return caughtTestException.get();
    }

    public static Throwable caughtExceptionAfterJunit() {
        return caughtExceptionAfterJunit.get();
    }

    public static void caughtExceptionAfterJunit(Throwable afterException) {
        if (afterException == null) {
            caughtExceptionAfterJunit.remove();
        } else {
            caughtExceptionAfterJunit.set(afterException);
        }
    }

    static void clean() {
        lastCreatedRunner.remove();
        deployableTest.remove();
        caughtInitializationException.remove();
        caughtExceptionAfterJunit.remove();
    }

    static {
        try {
            Arquillian.class.getClassLoader().loadClass("org.eclipse.jdt.internal.junit.runner.RemoteTestRunner");
            runningInEclipse = true;
        }
        catch (Exception e) {
            runningInEclipse = false;
        }
    }
}

