/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.security.csrf.verify;

import com.gargoylesoftware.htmlunit.Page;
import ee.jakarta.tck.mvc.tests.security.csrf.verify.AbstractCsrfVerifyTest;
import ee.jakarta.tck.mvc.tests.security.csrf.verify.CsrfProtectedController;
import ee.jakarta.tck.mvc.tests.security.csrf.verify.CsrfVerifyDefaultConfigApplication;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class CsrfVerifyDefaultConfigTest
extends AbstractCsrfVerifyTest {
    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive(CsrfVerifyDefaultConfigApplication.class).addClass(CsrfProtectedController.class).addView("csrf/verify/form.jsp").addView("csrf/verify/success.jsp").build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="cross-site-request-forgery", id="csrf-hidden-field"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-opt-default"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-mediatype")})
    public void submitFormWithAnnotationAndValidToken() throws IOException {
        Page resultPage = this.submitForm("with-annotation", true, "Alice");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Hi Alice!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="cross-site-request-forgery", id="csrf-opt-default"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-default-mapper")})
    public void submitFormWithAnnotationAndInvalidToken() throws IOException {
        Page resultPage = this.submitForm("with-annotation", false, "Bob");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)403));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="cross-site-request-forgery", id="csrf-hidden-field"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-opt-default"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-mediatype")})
    public void submitFormWithoutAnnotationAndValidToken() throws IOException {
        Page resultPage = this.submitForm("no-annotation", true, "Charlie");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Hi Charlie!"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="cross-site-request-forgery", id="csrf-opt-default"), @SpecAssertion(section="cross-site-request-forgery", id="csrf-mediatype")})
    public void submitFormWithoutAnnotationAndInvalidToken() throws IOException {
        Page resultPage = this.submitForm("no-annotation", false, "David");
        Assert.assertThat((Object)resultPage.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)resultPage.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Hi David!"));
    }
}

