/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlCaption;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTableBody;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class HtmlTable
extends HtmlElement {
    public static final String TAG_NAME = "table";

    HtmlTable(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final HtmlTableCell getCellAt(int rowIndex, int columnIndex) {
        RowIterator rowIterator = this.getRowIterator();
        HashSet<Point> occupied = new HashSet<Point>();
        int row = 0;
        for (HtmlTableRow htmlTableRow : rowIterator) {
            HtmlTableRow.CellIterator cellIterator = htmlTableRow.getCellIterator();
            int col = 0;
            for (HtmlTableCell cell : cellIterator) {
                while (occupied.contains(new Point(row, col))) {
                    ++col;
                }
                int nextRow = row + cell.getRowSpan();
                if (row <= rowIndex && nextRow > rowIndex) {
                    int nextCol = col + cell.getColumnSpan();
                    if (col <= columnIndex && nextCol > columnIndex) {
                        return cell;
                    }
                }
                if (cell.getRowSpan() > 1 || cell.getColumnSpan() > 1) {
                    for (int i = 0; i < cell.getRowSpan(); ++i) {
                        for (int j = 0; j < cell.getColumnSpan(); ++j) {
                            occupied.add(new Point(row + i, col + j));
                        }
                    }
                }
                ++col;
            }
            ++row;
        }
        return null;
    }

    private RowIterator getRowIterator() {
        return new RowIterator();
    }

    public List<HtmlTableRow> getRows() {
        ArrayList<HtmlTableRow> result = new ArrayList<HtmlTableRow>();
        for (HtmlTableRow row : this.getRowIterator()) {
            result.add(row);
        }
        return Collections.unmodifiableList(result);
    }

    public HtmlTableRow getRow(int index) throws IndexOutOfBoundsException {
        int count = 0;
        for (HtmlTableRow row : this.getRowIterator()) {
            if (count == index) {
                return row;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("No row found for index " + index + ".");
    }

    public final int getRowCount() {
        int count = 0;
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public final HtmlTableRow getRowById(String id) throws ElementNotFoundException {
        for (HtmlTableRow row : this.getRowIterator()) {
            if (!row.getId().equals(id)) continue;
            return row;
        }
        throw new ElementNotFoundException("tr", "id", id);
    }

    public String getCaptionText() {
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlCaption)) continue;
            return element.asText();
        }
        return null;
    }

    public HtmlTableHeader getHeader() {
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableHeader)) continue;
            return (HtmlTableHeader)element;
        }
        return null;
    }

    public HtmlTableFooter getFooter() {
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableFooter)) continue;
            return (HtmlTableFooter)element;
        }
        return null;
    }

    public List<HtmlTableBody> getBodies() {
        ArrayList<HtmlTableBody> bodies = new ArrayList<HtmlTableBody>();
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableBody)) continue;
            bodies.add((HtmlTableBody)element);
        }
        return bodies;
    }

    public final String getSummaryAttribute() {
        return this.getAttributeDirect("summary");
    }

    public final String getWidthAttribute() {
        return this.getAttributeDirect("width");
    }

    public final String getBorderAttribute() {
        return this.getAttributeDirect("border");
    }

    public final String getFrameAttribute() {
        return this.getAttributeDirect("frame");
    }

    public final String getRulesAttribute() {
        return this.getAttributeDirect("rules");
    }

    public final String getCellSpacingAttribute() {
        return this.getAttributeDirect("cellspacing");
    }

    public final String getCellPaddingAttribute() {
        return this.getAttributeDirect("cellpadding");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeDirect("bgcolor");
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.TABLE;
    }

    private class RowIterator
    implements Iterator<HtmlTableRow>,
    Iterable<HtmlTableRow> {
        private HtmlTableRow nextRow_;
        private TableRowGroup currentGroup_;

        RowIterator() {
            this.setNextRow(HtmlTable.this.getFirstChild());
        }

        @Override
        public boolean hasNext() {
            return this.nextRow_ != null;
        }

        @Override
        public HtmlTableRow next() throws NoSuchElementException {
            return this.nextRow();
        }

        @Override
        public void remove() {
            if (this.nextRow_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextRow_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public HtmlTableRow nextRow() throws NoSuchElementException {
            if (this.nextRow_ != null) {
                HtmlTableRow result = this.nextRow_;
                this.setNextRow(this.nextRow_.getNextSibling());
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextRow(DomNode node) {
            this.nextRow_ = null;
            for (DomNode next = node; next != null; next = next.getNextSibling()) {
                if (next instanceof HtmlTableRow) {
                    this.nextRow_ = (HtmlTableRow)next;
                    return;
                }
                if (this.currentGroup_ != null || !(next instanceof TableRowGroup)) continue;
                this.currentGroup_ = (TableRowGroup)next;
                this.setNextRow(next.getFirstChild());
                return;
            }
            if (this.currentGroup_ != null) {
                TableRowGroup group = this.currentGroup_;
                this.currentGroup_ = null;
                this.setNextRow(group.getNextSibling());
            }
        }

        @Override
        public Iterator<HtmlTableRow> iterator() {
            return this;
        }
    }
}

