/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.xpath;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.xpath.HtmlUnitPrefixResolver;
import com.gargoylesoftware.htmlunit.html.xpath.XPathAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathHelper {
    private static ThreadLocal<Boolean> PROCESS_XPATH_ = ThreadLocal.withInitial(() -> Boolean.FALSE);

    private XPathHelper() {
    }

    public static <T> List<T> getByXPath(DomNode node, String xpathExpr, PrefixResolver resolver, boolean caseSensitiveXpathAttributes) {
        ArrayList<Object> list;
        block11: {
            if (xpathExpr == null) {
                throw new IllegalArgumentException("Null is not a valid XPath expression");
            }
            PROCESS_XPATH_.set(Boolean.TRUE);
            list = new ArrayList<Object>();
            try {
                XObject result = XPathHelper.evaluateXPath(node, xpathExpr, resolver, caseSensitiveXpathAttributes);
                if (result instanceof XNodeSet) {
                    NodeList nodelist = ((XNodeSet)result).nodelist();
                    for (int i = 0; i < nodelist.getLength(); ++i) {
                        list.add(nodelist.item(i));
                    }
                    break block11;
                }
                if (result instanceof XNumber) {
                    list.add(result.num());
                    break block11;
                }
                if (result instanceof XBoolean) {
                    list.add(result.bool());
                    break block11;
                }
                if (result instanceof XString) {
                    list.add(result.str());
                    break block11;
                }
                throw new RuntimeException("Unproccessed " + result.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not retrieve XPath >" + xpathExpr + "< on " + node, e);
            }
            finally {
                PROCESS_XPATH_.set(Boolean.FALSE);
            }
        }
        return list;
    }

    public static boolean isProcessingXPath() {
        return PROCESS_XPATH_.get();
    }

    private static XObject evaluateXPath(DomNode contextNode, String str, PrefixResolver prefixResolver, boolean caseSensitiveXpathAttributes) throws TransformerException {
        boolean caseSensitive;
        XPathContext xpathSupport = new XPathContext();
        Node xpathExpressionContext = contextNode.getNodeType() == 9 ? ((Document)((Object)contextNode)).getDocumentElement() : contextNode;
        Object resolver = prefixResolver;
        if (resolver == null) {
            resolver = new HtmlUnitPrefixResolver(xpathExpressionContext);
        }
        boolean attributeCaseSensitive = (caseSensitive = contextNode.getPage().hasCaseSensitiveTagNames()) || caseSensitiveXpathAttributes;
        XPathAdapter xpath = new XPathAdapter(str, null, (PrefixResolver)resolver, null, caseSensitive, attributeCaseSensitive);
        int ctxtNode = xpathSupport.getDTMHandleFromNode((Node)contextNode);
        return xpath.execute(xpathSupport, ctxtNode, prefixResolver);
    }
}

