/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.select;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Vehicle;
import ee.jakarta.tck.nosql.factories.VehicleListSupplier;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The query execution exploring filters with enum")
public class SelectEnumTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=VehicleListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with equals enum value")
    void shouldInsertIterableAndSelectWithEnumCondition(List<Vehicle> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Vehicle.class).where("transmission").eq((Object)entities.get(0).getTransmission()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(vehicle -> vehicle.getTransmission().equals((Object)((Vehicle)entities.get(0)).getTransmission()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=VehicleListSupplier.class)
    @DisplayName(value="Should insert Iterable and delete with equals enum value")
    void shouldInsertIterableAndDeleteWithEnumCondition(List<Vehicle> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            this.template.delete(Vehicle.class).where("transmission").eq((Object)entities.get(0).getTransmission()).execute();
            List result = this.template.select(Vehicle.class).where("transmission").eq((Object)entities.get(0).getTransmission()).result();
            Assertions.assertThat((List)result).isEmpty();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

