/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.select;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Fruit;
import ee.jakarta.tck.nosql.factories.FruitListSupplier;
import jakarta.nosql.Template;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="Query execution with @Convert annotated fields in Fruit entity")
public class SelectFieldConvertTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with converted quantity equals condition")
    void shouldInsertIterableAndSelectWithQuantityEqualsCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            Long targetQuantity = entities.get(0).getQuantity();
            List result = this.template.select(Fruit.class).where("quantity").eq((Object)targetQuantity).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(fruit -> fruit.getQuantity().equals(targetQuantity));
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with quantity greater-than condition")
    void shouldInsertIterableAndSelectWithQuantityGreaterThanCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            long targetQuantity = entities.get(0).getQuantity() - 1L;
            List result = this.template.select(Fruit.class).where("quantity").gt((Object)targetQuantity).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(fruit -> fruit.getQuantity() > targetQuantity);
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with quantity less-than condition")
    void shouldInsertIterableAndSelectWithQuantityLessThanCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            long targetQuantity = entities.get(0).getQuantity() + 10L;
            List result = this.template.select(Fruit.class).where("quantity").lt((Object)targetQuantity).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(fruit -> fruit.getQuantity() < targetQuantity);
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=FruitListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with quantity between condition")
    void shouldInsertIterableAndSelectWithQuantityBetweenCondition(List<Fruit> entities) {
        entities.forEach(arg_0 -> ((Template)this.template).insert(arg_0));
        try {
            Long targetQuantity = entities.get(0).getQuantity();
            List result = this.template.select(Fruit.class).where("quantity").between((Object)(targetQuantity - 5L), (Object)(targetQuantity + 5L)).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(fruit -> {
                Long quantity = fruit.getQuantity();
                return quantity >= targetQuantity - 5L && quantity <= targetQuantity + 5L;
            });
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

