/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.select;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Person;
import ee.jakarta.tck.nosql.factories.PersonListSupplier;
import java.util.Comparator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="Select Negate Query Tests")
public class SelectNegateTemplateTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated condition")
    void shouldInsertIterableAndSelectWithNegatedCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Person.class).where("name").not().eq((Object)entities.get(0).getName()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> !person.getName().equals(((Person)entities.get(0)).getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated greater-than condition")
    void shouldInsertIterableAndSelectWithNegatedGreaterThanCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").not().gt((Object)secondElder).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() <= secondElder);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated less-than condition")
    void shouldInsertIterableAndSelectWithNegatedLessThanCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").not().lt((Object)secondElder).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() >= secondElder);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated LIKE condition")
    void shouldInsertIterableAndSelectWithNegatedLikeCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Person.class).where("name").not().like(entities.get(0).getName()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> !person.getName().contains(((Person)entities.get(0)).getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated 'in' condition")
    void shouldInsertIterableAndSelectWithNegatedInCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Person.class).where("name").not().in(List.of(entities.get(0).getName())).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> !person.getName().equals(((Person)entities.get(0)).getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated 'between' condition")
    void shouldInsertIterableAndSelectWithNegatedBetweenCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").not().between((Object)secondElder, (Object)(secondElder + 5)).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() < secondElder || person.getAge() > secondElder + 5);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated complex query using 'and'")
    void shouldInsertIterableAndSelectWithNegatedComplexQueryAnd(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Person secondElder = entities.stream().sorted(Comparator.comparing(Person::getAge)).skip(entities.size() - 1).findFirst().orElseThrow();
            int age = secondElder.getAge() - 1;
            String name = secondElder.getName();
            List result = this.template.select(Person.class).where("age").not().gt((Object)age).and("name").not().eq((Object)name).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() <= age && !person.getName().equals(name));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with negated complex query using 'or'")
    void shouldInsertIterableAndSelectWithNegatedComplexQueryOr(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Person secondElder = entities.stream().sorted(Comparator.comparing(Person::getAge)).skip(entities.size() - 1).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").not().gt((Object)secondElder.getAge()).or("name").not().eq((Object)secondElder.getName()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() <= secondElder.getAge() || !person.getName().equals(secondElder.getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

