/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Department2;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Department3;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Department4;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.EmbeddedEmployee;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Employee;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Employee2;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Employee3;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Employee4;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Numbers;
import ee.jakarta.tck.persistence.core.annotations.mapkeyenumerated.Offices;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 20L;
    private static Employee[] empRef = new Employee[5];
    private static Employee2[] empRef2 = new Employee2[5];
    private static Employee3[] empRef3 = new Employee3[5];
    private static Employee4[] empRef4 = new Employee4[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void mapKeyEnumeratedTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Offices> expected = new HashSet<Offices>();
        expected.add(Offices.OFF000);
        expected.add(Offices.OFF002);
        expected.add(Offices.OFF004);
        try {
            this.getEntityTransaction().begin();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            this.logTrace("Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map<Offices, Employee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<Offices, Employee> entry : emps.entrySet()) {
                    this.logTrace("map:" + (Object)((Object)entry.getKey()) + ", " + entry.getValue().getId() + " " + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                }
            }
            Set<Offices> keys = emps.keySet();
            for (Offices key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (Offices key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (Offices key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee> hashSet = new HashSet<Employee>();
            hashSet.add(empRef[0]);
            hashSet.add(empRef[1]);
            hashSet.add(empRef[2]);
            Collection<Employee> employees = emps.values();
            for (Employee e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("mapKeyEnumeratedTest failed");
        }
    }

    public void mapKeyEnumeratedDefaultTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Offices> expected = new HashSet<Offices>();
        expected.add(Offices.OFF001);
        expected.add(Offices.OFF003);
        try {
            this.getEntityTransaction().begin();
            Employee2 emp = (Employee2)this.getEntityManager().find(Employee2.class, (Object)2);
            this.logTrace("Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department2 dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map<Offices, Employee2> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<Offices, Employee2> entry : emps.entrySet()) {
                    this.logTrace("map:" + (Object)((Object)entry.getKey()) + ", " + entry.getValue().getId() + " " + entry.getValue().getFirstName() + " " + entry.getValue().getLastName());
                }
            }
            Set<Offices> keys = emps.keySet();
            for (Offices key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (Offices key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (Offices key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee2> hashSet = new HashSet<Employee2>();
            hashSet.add(empRef2[0]);
            hashSet.add(empRef2[1]);
            Collection<Employee2> employees = emps.values();
            for (Employee2 e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee2 e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee2 e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("mapKeyEnumeratedDefaultTypeTest failed");
        }
    }

    public void mapKeyEnumeratedWithMayKeyAnnotationTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Offices> expected = new HashSet<Offices>();
        expected.add(Offices.OFF001);
        expected.add(Offices.OFF003);
        try {
            this.getEntityTransaction().begin();
            Employee3 emp = (Employee3)this.getEntityManager().find(Employee3.class, (Object)6);
            this.logTrace("Name:" + emp.getFirstName() + " " + emp.getLastName());
            Department3 dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry entry : emps.entrySet()) {
                    this.logTrace("map:" + entry.getKey() + ", " + ((Employee3)entry.getValue()).getId() + " " + ((Employee3)entry.getValue()).getFirstName() + " " + ((Employee3)entry.getValue()).getLastName());
                }
            }
            Set keys = emps.keySet();
            for (Offices key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (Offices key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (Offices key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee3> hashSet = new HashSet<Employee3>();
            hashSet.add(empRef3[0]);
            hashSet.add(empRef3[1]);
            Collection employees = emps.values();
            for (Employee3 e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee3 e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee3 e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getFirstName() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("mapKeyEnumeratedWithMayKeyAnnotationTest failed");
        }
    }

    public void elementCollectionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        HashSet<Numbers> expected = new HashSet<Numbers>();
        expected.add(Numbers.one);
        expected.add(Numbers.two);
        try {
            this.getEntityTransaction().begin();
            Employee4 emp = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            this.logTrace("Name:" + emp.getLastName());
            Department4 dept = emp.getDepartment();
            this.logTrace("Dept=" + dept.getName());
            Map<Numbers, EmbeddedEmployee> emps = dept.getLastNameEmployees();
            if (TestUtil.traceflag) {
                for (Map.Entry<Numbers, EmbeddedEmployee> entry : emps.entrySet()) {
                    this.logTrace("map:" + (Object)((Object)entry.getKey()) + ", " + entry.getValue().employeeId + " " + entry.getValue().employeeName);
                }
            }
            Set<Numbers> keys = emps.keySet();
            for (Numbers key : keys) {
                this.logTrace("key:" + key);
            }
            if (expected.containsAll(keys) && keys.containsAll(expected) && expected.size() == keys.size()) {
                this.logTrace("Received expected keys");
                pass1 = true;
            } else {
                this.logErr("Did not received expected keys");
                this.logErr("Expected:");
                for (Numbers key : expected) {
                    this.logTrace("key:" + key);
                }
                this.logErr("Actual:");
                for (Numbers key : keys) {
                    this.logTrace("key:" + key);
                }
            }
            HashSet<Employee4> hashSet = new HashSet<Employee4>();
            hashSet.add(empRef4[0]);
            hashSet.add(empRef4[1]);
            Collection employees = emps.values().stream().flatMap(a -> Stream.of(new Employee4(a.employeeId, a.employeeName))).collect(Collectors.toList());
            for (Employee4 e : employees) {
                this.logTrace("values:" + e.getId() + " " + e.getLastName());
            }
            if (hashSet.containsAll(employees) && employees.containsAll(hashSet) && hashSet.size() == employees.size()) {
                this.logTrace("Received expected values");
                pass2 = true;
            } else {
                this.logErr("Did not received expected values");
                this.logErr("Expected:");
                for (Employee4 e : hashSet) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
                this.logErr("Actual:");
                for (Employee4 e : employees) {
                    this.logTrace("Employee:" + e.getId() + " " + e.getLastName());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception ex) {
            this.logErr("Unexpected exception occurred", ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("elementCollectionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        this.logTrace("createTestData");
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Create 2 - Departments");
            Department[] deptRef = new Department[]{new Department(1, "Marketing"), new Department(2, "Administration")};
            this.logTrace("Persist departments ");
            for (Department dept : deptRef) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department " + dept.getName());
            }
            this.logTrace("Create 2 - Department2");
            Department2[] deptRef2 = new Department2[]{new Department2(3, "Development"), new Department2(4, "Release")};
            this.logTrace("Persist Department2s ");
            for (Department2 dept : deptRef2) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department2 " + dept.getName());
            }
            this.logTrace("Create 2 - Department3");
            Department3[] deptRef3 = new Department3[]{new Department3(5, "Shipping"), new Department3(6, "Receiving")};
            this.logTrace("Persist Department2s ");
            for (Department3 dept : deptRef3) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department3 " + dept.getName());
            }
            this.logTrace("Create 2 - Department4");
            Department4[] deptRef4 = new Department4[]{new Department4(7, "Accounts_Receivable"), new Department4(8, "Accounts_Payable")};
            this.logTrace("Persist Department4 ");
            for (Department4 dept : deptRef4) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department4 " + dept.getName());
            }
            this.logTrace("Create 5 - Employee");
            Client.empRef[0] = new Employee(1, "Alan", "Frechette");
            empRef[0].setDepartment(deptRef[0]);
            Client.empRef[1] = new Employee(3, "Shelly", "McGowan");
            empRef[1].setDepartment(deptRef[0]);
            Client.empRef[2] = new Employee(5, "Stephen", "DMilla");
            empRef[2].setDepartment(deptRef[0]);
            Client.empRef2[0] = new Employee2(2, "Arthur", "Frechette");
            empRef2[0].setDepartment(deptRef2[0]);
            Client.empRef2[1] = new Employee2(4, "Robert", "Bissett");
            empRef2[1].setDepartment(deptRef2[0]);
            Client.empRef3[0] = new Employee3(6, "Douglas", "Donahue");
            empRef3[0].setDepartment(deptRef3[0]);
            Client.empRef3[1] = new Employee3(7, "Kellie", "Sanborn");
            empRef3[1].setDepartment(deptRef3[0]);
            Client.empRef4[0] = new Employee4(8, "Grace");
            empRef4[0].setDepartment(deptRef4[0]);
            Client.empRef4[1] = new Employee4(9, "Bender");
            empRef4[1].setDepartment(deptRef4[1]);
            HashMap<Offices, Employee> link = new HashMap<Offices, Employee>();
            link.put(Offices.OFF000, empRef[0]);
            link.put(Offices.OFF002, empRef[1]);
            link.put(Offices.OFF004, empRef[2]);
            deptRef[0].setLastNameEmployees(link);
            HashMap<Offices, Employee2> link2 = new HashMap<Offices, Employee2>();
            link2.put(Offices.OFF001, empRef2[0]);
            link2.put(Offices.OFF003, empRef2[1]);
            deptRef2[0].setLastNameEmployees(link2);
            HashMap<Offices, Employee3> link3 = new HashMap<Offices, Employee3>();
            link3.put(Offices.OFF001, empRef3[0]);
            link3.put(Offices.OFF003, empRef3[1]);
            deptRef3[0].setLastNameEmployees(link3);
            HashMap<Numbers, EmbeddedEmployee> link4 = new HashMap<Numbers, EmbeddedEmployee>();
            link4.put(Numbers.one, new EmbeddedEmployee(empRef4[0]));
            link4.put(Numbers.two, new EmbeddedEmployee(empRef4[1]));
            deptRef4[0].setLastNameEmployees(link4);
            this.logTrace("Persist Employee ");
            for (Employee employee : empRef) {
                if (employee == null) continue;
                this.getEntityManager().persist((Object)employee);
                this.logTrace("persisted Employee " + employee.getId());
            }
            this.logTrace("Persist Employee2 ");
            for (Serializable serializable : empRef2) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted Employee2 " + ((Employee2)serializable).getId());
            }
            this.logTrace("Persist Employee3 ");
            for (Serializable serializable : empRef3) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted Employee3 " + ((Employee3)serializable).getId());
            }
            this.logTrace("Persist Employee4 ");
            for (Serializable serializable : empRef4) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted Employee4 " + ((Employee4)serializable).getId());
            }
            this.logTrace("Merge Department ");
            for (Serializable serializable : deptRef) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged Department " + ((Department)serializable).getName());
            }
            this.logTrace("Merge Department2 ");
            for (Serializable serializable : deptRef2) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged Department2 " + ((Department2)serializable).getName());
            }
            this.logTrace("Merge Department3 ");
            for (Serializable serializable : deptRef3) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged Department3 " + ((Department3)serializable).getName());
            }
            this.logTrace("Merge Department4 ");
            for (Serializable serializable : deptRef4) {
                if (serializable == null) continue;
                this.getEntityManager().merge((Object)serializable);
                this.logTrace("merged Department4 " + ((Department4)serializable).getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from EMP_MAPKEYCOL2").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

