/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.ordercolumn;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Course;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Department;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Department2;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Employee;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Employee2;
import ee.jakarta.tck.persistence.core.annotations.ordercolumn.Student;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Client2
extends PMClientBase {
    private List<Student> expectedResults;
    private List<Employee> expectedEmployees;
    private List<Employee2> expectedEmployees2;

    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeEmployeeTestData();
            this.createEmployeeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void propertyAccessWithNameTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department d = (Department)this.getEntityManager().find(Department.class, (Object)50);
            this.logMsg("Display find data");
            for (Employee e : d.getEmployees()) {
                this.logMsg("Employee:" + e);
            }
            ArrayList<Employee> actual = new ArrayList<Employee>();
            TypedQuery q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 0", Employee.class);
            Employee emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                this.logErr("Query of INDEX(0) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 1", Employee.class);
            emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                this.logErr("Query of INDEX(1) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 2", Employee.class);
            emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                this.logErr("Query of INDEX(2) returned null result");
            }
            if (actual.size() == this.expectedEmployees.size()) {
                int count = 0;
                for (int i = 0; i < this.expectedEmployees.size(); ++i) {
                    this.logTrace("Testing - expected[" + this.expectedEmployees.get(i) + "], actual[" + actual.get(i) + "]");
                    if (!this.expectedEmployees.get(i).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == this.expectedEmployees.size()) {
                    pass = true;
                } else {
                    this.logTrace("count=" + count + ", expected size:" + this.expectedEmployees.size());
                    for (Employee e : this.expectedEmployees) {
                        this.logErr("expected:" + e);
                    }
                    this.logErr("------------");
                    for (Employee e : actual) {
                        this.logErr("actual:" + e);
                    }
                }
            } else {
                this.logErr("Expected list size:" + this.expectedEmployees.size() + ", actual size:" + actual.size());
                for (Employee e : this.expectedEmployees) {
                    this.logErr("expected:" + e);
                }
                this.logErr("------------");
                for (Employee e : actual) {
                    this.logErr("actual:" + e);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
        }
        if (!pass) {
            throw new Exception("propertyAccessWithNameTest test failed");
        }
    }

    public void fieldAccessWithNameTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department2 d = (Department2)this.getEntityManager().find(Department2.class, (Object)55);
            this.logMsg("Display find data");
            for (Employee2 e : d.getEmployees()) {
                this.logMsg("Employee2:" + e);
            }
            ArrayList<Employee2> actual = new ArrayList<Employee2>();
            TypedQuery q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 0", Employee2.class);
            Employee2 emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                this.logErr("Query of INDEX(0) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 1", Employee2.class);
            emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                this.logErr("Query of INDEX(1) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 2", Employee2.class);
            emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                this.logErr("Query of INDEX(2) returned null result");
            }
            if (actual.size() == this.expectedEmployees2.size()) {
                int count = 0;
                for (int i = 0; i < this.expectedEmployees2.size(); ++i) {
                    this.logTrace("Testing - expected[" + this.expectedEmployees2.get(i) + "], actual[" + actual.get(i) + "]");
                    if (!this.expectedEmployees2.get(i).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == this.expectedEmployees.size()) {
                    pass = true;
                } else {
                    this.logTrace("count=" + count + ", expected size:" + this.expectedEmployees2.size());
                    for (Employee2 e : this.expectedEmployees2) {
                        this.logErr("expected:" + e);
                    }
                    this.logErr("------------");
                    for (Employee2 e : actual) {
                        this.logErr("actual:" + e);
                    }
                }
            } else {
                this.logErr("Expected list size:" + this.expectedEmployees2.size() + ", actual size:" + actual.size());
                for (Employee2 e : this.expectedEmployees2) {
                    this.logErr("expected:" + e);
                }
                this.logErr("------------");
                for (Employee2 e : actual) {
                    this.logErr("actual:" + e);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
        }
        if (!pass) {
            throw new Exception("fieldAccessWithNameTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStudentTestData() {
        try {
            this.logTrace("createTestData");
            this.getEntityTransaction().begin();
            Student student1 = new Student(1, "Neo");
            Student student2 = new Student(2, "Vivek");
            Student student3 = new Student(3, "Arun");
            Student student4 = new Student(4, "Ganesh");
            Student student5 = new Student(5, "Ram");
            Student student6 = new Student(6, "Rahim");
            Student student7 = new Student(7, "Joseph");
            Student student8 = new Student(8, "Krishna");
            Course appliedMath = new Course(101, "AppliedMathematics");
            Course physics = new Course(102, "Physics");
            Course operationResearch = new Course(103, "OperationResearch");
            Course statistics = new Course(201, "Statistics");
            Course operatingSystem = new Course(202, "OperatingSystem");
            ArrayList<Student> studentList1 = new ArrayList<Student>();
            studentList1.add(student1);
            studentList1.add(student7);
            studentList1.add(student2);
            studentList1.add(student8);
            this.expectedResults = new ArrayList<Student>();
            this.expectedResults.addAll(studentList1);
            ArrayList<Student> studentList2 = new ArrayList<Student>();
            studentList2.add(student3);
            studentList2.add(student4);
            ArrayList<Student> studentList3 = new ArrayList<Student>();
            studentList3.add(student5);
            studentList3.add(student6);
            ArrayList<Student> studentList4 = new ArrayList<Student>();
            studentList4.add(student7);
            studentList4.add(student8);
            appliedMath.setStudents(studentList1);
            physics.setStudents(studentList1);
            operationResearch.setStudents(studentList1);
            statistics.setStudents(studentList2);
            operatingSystem.setStudents(studentList2);
            ArrayList<Course> firstSemCourses = new ArrayList<Course>();
            firstSemCourses.add(appliedMath);
            firstSemCourses.add(physics);
            firstSemCourses.add(operationResearch);
            ArrayList<Course> secondSemCourses = new ArrayList<Course>();
            secondSemCourses.add(statistics);
            secondSemCourses.add(operatingSystem);
            student1.setCourses(firstSemCourses);
            student2.setCourses(firstSemCourses);
            student3.setCourses(secondSemCourses);
            student4.setCourses(secondSemCourses);
            student5.setCourses(secondSemCourses);
            student6.setCourses(secondSemCourses);
            student7.setCourses(firstSemCourses);
            student8.setCourses(firstSemCourses);
            EntityManager entityManager = this.getEntityManager();
            entityManager.persist((Object)student1);
            entityManager.persist((Object)student2);
            entityManager.persist((Object)student3);
            entityManager.persist((Object)student4);
            entityManager.persist((Object)student5);
            entityManager.persist((Object)student6);
            entityManager.persist((Object)student7);
            entityManager.persist((Object)student8);
            this.logTrace("persisted 8 students");
            entityManager.persist((Object)appliedMath);
            entityManager.persist((Object)physics);
            entityManager.persist((Object)operationResearch);
            entityManager.persist((Object)statistics);
            entityManager.persist((Object)operatingSystem);
            this.logTrace("persisted 5 Courses");
            this.logTrace("persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeTestData() throws Exception {
        try {
            this.logTrace("createEmployeeTestData");
            this.getEntityTransaction().begin();
            Department d1 = new Department(50, "Dept1");
            Department2 d2 = new Department2(55, "Dept2");
            this.getEntityManager().persist((Object)d1);
            Employee e1 = new Employee(20, "Jie", "Leng", 0.0f, d1);
            Employee e2 = new Employee(40, "Zoe", "Leng", 0.0f, d1);
            Employee e3 = new Employee(60, "John", "Smith", 0.0f, d1);
            Employee2 e4 = new Employee2(80, "Song", "Leng", 0.0f, d2);
            Employee2 e5 = new Employee2(100, "May", "Leng", 0.0f, d2);
            Employee2 e6 = new Employee2(120, "Donny", "Oz", 0.0f, d2);
            this.getEntityManager().persist((Object)e1);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().persist((Object)e3);
            this.getEntityManager().persist((Object)e4);
            this.getEntityManager().persist((Object)e5);
            this.getEntityManager().persist((Object)e6);
            this.expectedEmployees = new ArrayList<Employee>();
            this.expectedEmployees.add(e3);
            this.expectedEmployees.add(e1);
            this.expectedEmployees.add(e2);
            d1.setEmployees(this.expectedEmployees);
            this.getEntityManager().merge((Object)d1);
            this.expectedEmployees2 = new ArrayList<Employee2>();
            this.expectedEmployees2.add(e6);
            this.expectedEmployees2.add(e4);
            this.expectedEmployees2.add(e5);
            d2.setEmployees(this.expectedEmployees2);
            this.getEntityManager().merge((Object)d2);
            this.logTrace("persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanupEmployee() throws Exception {
        this.logTrace("cleanupEmployee");
        this.removeEmployeeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeEmployeeTestData() {
        this.logTrace("removeEmployeeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

