/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.metamodelapi.type;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.metamodelapi.type.Address;
import ee.jakarta.tck.persistence.core.metamodelapi.type.Order;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void getPersistenceType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Type.PersistenceType type = mTypeOrder.getPersistenceType();
                this.logTrace("Obtained Non-null ManagedType");
                if (type.equals((Object)Type.PersistenceType.ENTITY)) {
                    pass = true;
                } else {
                    this.logTrace("Persistence type = " + type.name());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getPersistenceType Test  failed");
        }
    }

    public void getEmbeddablePersistenceType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eTypeAddress = metaModel.embeddable(Address.class);
            if (eTypeAddress != null) {
                Type.PersistenceType type = eTypeAddress.getPersistenceType();
                this.logTrace("Obtained Non-null Embeddable Type");
                if (type.equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                    pass = true;
                } else {
                    this.logTrace("Persistence type = " + type);
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getEmbeddablePersistenceType Test  failed");
        }
    }

    public void getJavaType() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            this.logTrace("Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Class javaType = mTypeOrder.getJavaType();
                this.logTrace("Obtained Non-null ManagedType");
                if (javaType.getName().equals("ee.jakarta.tck.persistence.core.metamodelapi.type.Order")) {
                    pass = true;
                } else {
                    this.logTrace("javaType name = " + javaType.getName());
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("getJavaType Test  failed");
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

