/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.nocallbacklistener;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.nocallbacklistener.NoCallBackListener;
import ee.jakarta.tck.persistence.core.override.util.CallBackCounts;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 1L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void testNoCallBackListener() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CallBackCounts.clearCountsMap();
        NoCallBackListener entity = new NoCallBackListener();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        this.logTrace("persisted entity" + entity);
        this.getEntityManager().flush();
        this.getEntityManager().refresh((Object)entity);
        NoCallBackListener newEntity = null;
        List result = this.getEntityManager().createQuery("SELECT n FROM NoCallBackListener n").getResultList();
        if (result != null && result.size() > 0) {
            newEntity = (NoCallBackListener)result.get(0);
            if (newEntity.getId() == 1L) {
                this.logTrace("Retrieved persisted entity");
            }
            this.getEntityManager().remove((Object)entity);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            try {
                pass1 = this.checkPersistCallBacks();
                this.logTrace("pass1 = " + pass1);
                pass2 = this.checkRemoveCallBacks();
                this.logTrace("pass2 = " + pass2);
                pass3 = this.checkLoadCallBacks();
                this.logTrace("pass3 = " + pass3);
                if (!(pass1 && pass2 && pass3)) {
                    throw new Exception("Test failed while testing prePersist, postPersist, preremove and postremove methods and also the post Load method");
                }
                this.logTrace("testOverrideCallBackMethods Passed");
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoCallBackListener" + e);
            }
        } else {
            throw new Exception("getResultList returned a null list");
        }
    }

    private boolean checkPersistCallBacks() throws Exception {
        boolean result = false;
        if (this.test("prePersistFromXML", 1) && this.test("postPersist", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws Exception {
        boolean result = false;
        if (this.test("preRemoveFromXML", 1) && this.test("postRemoveFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkLoadCallBacks() throws Exception {
        boolean result = false;
        if (this.test("postLoadFromXML", 1)) {
            return true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws Exception {
        boolean pass = false;
        int count = CallBackCounts.getCount(callBackName);
        if (count == expectedCount) {
            this.logTrace("test passed in test method" + callBackName);
            pass = true;
        } else {
            this.logTrace("test not passed as the count and the expected count are not same" + callBackName);
        }
        return pass;
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

