/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.bean.types.enterprise;

import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Animal;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Bird;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Cobra;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Creature;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.LegendaryCreature;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.LegendaryLocal;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.LoginActionBean;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Mammal;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Mock;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.MockLoginActionBean;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Snake;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Vulture;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SessionBeanTypesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionBeanTypesTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_bean_types", id="aa"), @SpecAssertion(section="session_bean_types", id="ba"), @SpecAssertion(section="session_bean_types", id="c")})
    public void testGenericHierarchyBeanTypes() {
        Bean vultureBean = this.getUniqueBean(Vulture.class, new Annotation[0]);
        org.testng.Assert.assertNotNull((Object)vultureBean);
        org.testng.Assert.assertEquals((int)vultureBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches((Set)vultureBean.getTypes(), (Type[])new Type[]{Object.class, Vulture.class, new TypeLiteral<Bird<Integer>>(){}.getType()});
        TypeLiteral<Mammal<String>> mammalLiteral = new TypeLiteral<Mammal<String>>(){};
        Bean tigerBean = this.getUniqueBean((TypeLiteral)mammalLiteral, new Annotation[0]);
        org.testng.Assert.assertNotNull((Object)tigerBean);
        org.testng.Assert.assertEquals((int)tigerBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches((Set)tigerBean.getTypes(), (Type[])new Type[]{Object.class, new TypeLiteral<Animal<String>>(){}.getType(), mammalLiteral.getType()});
        Bean creatureBean = this.getUniqueBean(LegendaryCreature.class, new Annotation[0]);
        org.testng.Assert.assertNotNull((Object)creatureBean);
        org.testng.Assert.assertEquals((int)creatureBean.getTypes().size(), (int)4);
        Assert.assertTypeSetMatches((Set)creatureBean.getTypes(), (Type[])new Type[]{Object.class, LegendaryCreature.class, LegendaryLocal.class, Creature.class});
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_bean_types", id="aa"), @SpecAssertion(section="session_bean_types", id="ba"), @SpecAssertion(section="session_bean_types", id="c")})
    public void testSessionBeanWithBothLocalInterfaceAndNoInterfaceView() {
        Bean creatureBean = this.getUniqueBean(LegendaryCreature.class, new Annotation[0]);
        org.testng.Assert.assertNotNull((Object)creatureBean);
        org.testng.Assert.assertEquals((int)creatureBean.getTypes().size(), (int)4);
        Assert.assertTypeSetMatches((Set)creatureBean.getTypes(), (Type[])new Type[]{Object.class, LegendaryCreature.class, LegendaryLocal.class, Creature.class});
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="session_bean_types", id="ba")
    public void testSessionBeanExtendingSessionBeanWithLocalClientView() {
        Bean loginBean = this.getUniqueBean(MockLoginActionBean.class, new Annotation[]{new Mock.Literal()});
        org.testng.Assert.assertNotNull((Object)loginBean);
        org.testng.Assert.assertEquals((int)loginBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches((Set)loginBean.getTypes(), (Type[])new Type[]{Object.class, LoginActionBean.class, MockLoginActionBean.class});
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="session_bean_types", id="ba")
    public void testSessionBeanWithNoInterfaceView() {
        Bean cobraBean = this.getUniqueBean(Cobra.class, new Annotation[0]);
        org.testng.Assert.assertNotNull((Object)cobraBean);
        org.testng.Assert.assertEquals((int)cobraBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches((Set)cobraBean.getTypes(), (Type[])new Type[]{Object.class, Cobra.class, Snake.class});
    }
}

