/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.lite;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.common.vehicle.ejbliteshare.EJBLiteClientIF;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import jakarta.ejb.EJBException;
import jakarta.ejb.embeddable.EJBContainer;
import jakarta.faces.annotation.ManagedProperty;
import jakarta.inject.Inject;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class EJBLiteJsfClientBase
extends ServiceEETest
implements EJBLiteClientIF {
    private String status;
    private String reason;
    @Inject
    @ManagedProperty(value="#{param.testName}")
    private String testName;
    private Boolean injectionSupported;
    @Inject
    @ManagedProperty(value="#{facesContext.externalContext.requestContextPath}")
    private String moduleName;
    private EJBContainer container;
    private Context context;
    private Map<String, String> jndiMapping = new HashMap<String, String>();
    private File[] additionalModules;
    private StringBuilder reasonBuffer;
    private byte accessCount;
    private boolean inVehicle;

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getStatus() {
        if (this.accessCount == 0) {
            this.runTestInVehicle();
        } else {
            this.passOrFail(false, "This class has been incorrectly shared across multiple tests: ", ((Object)((Object)this)).toString(), ", timesCalled=", String.valueOf(this.accessCount));
        }
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getReason() {
        if (this.reason == null) {
            this.reason = this.reasonBuffer == null ? "WARNING: both reason and reasonBuffer is null." : this.reasonBuffer.toString();
        }
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getModuleName() {
        if (this.moduleName.startsWith("/")) {
            return this.moduleName.substring(1);
        }
        return this.moduleName;
    }

    public void setModuleName(String mn) {
        this.moduleName = mn.startsWith("/") ? mn.substring(1) : mn;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    public void setContainer(EJBContainer container) {
        this.container = container;
    }

    public Context getContext() {
        if (this.context != null) {
            return this.context;
        }
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return ctx;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setup(String[] args, Properties p) {
        if (!this.inVehicle && this.testName == null && p != null) {
            String s = p.getProperty("testName");
            this.testName = s.substring(0, s.indexOf("_from_"));
            String m = p.getProperty("vehicle_archive_name");
            this.setModuleName(m);
            Helper.getLogger().fine("testName from test properties: " + s + ", setting testName field to the short name: " + this.testName + ". set moduleName to vehicle_archive_name property: " + m);
        }
    }

    public void cleanup() {
        if (!this.inVehicle) {
            Helper.getLogger().info("The following events occurred before test passed or failed: " + this.getReason());
        }
        this.nuke();
    }

    public void runTestInVehicle() {
        this.inVehicle = true;
        try {
            this.setup(null, null);
            Method testMethod = ((Object)((Object)this)).getClass().getMethod(this.testName, new Class[0]);
            testMethod.invoke((Object)this, (Object[])null);
            this.passOrFail(true, new String[0]);
        }
        catch (NoSuchMethodException e) {
            this.passOrFail(false, "Failed to get test method " + this.testName, e.toString());
        }
        catch (IllegalAccessException e) {
            this.passOrFail(false, "Failed to access test method (is it public?) " + this.testName, e.toString());
        }
        catch (InvocationTargetException e) {
            Throwable cause2;
            String msg = "Failed with exception ";
            Throwable root = e.getCause();
            if (root == null) {
                root = e;
            } else if (root instanceof EJBException && (cause2 = root.getCause()) != null) {
                root = cause2;
                msg = "Failed with EJBException caused by ";
            }
            this.passOrFail(false, msg, TestUtil.printStackTraceToString((Throwable)root));
        }
        catch (Exception e) {
            this.passOrFail(false, "Unexpected exception for test " + this.testName, TestUtil.printStackTraceToString((Throwable)e));
        }
    }

    public Boolean getInjectionSupported() {
        return this.injectionSupported;
    }

    public void setInjectionSupported(Boolean injectionSupported) {
        this.injectionSupported = injectionSupported;
    }

    public Map<String, String> getJndiMapping() {
        return this.jndiMapping;
    }

    public void setContextClassLoader() {
    }

    public Map<String, Object> getContainerInitProperties() {
        return null;
    }

    public void setAdditionalModules(File[] additionalModules) {
        this.additionalModules = additionalModules;
    }

    protected Object lookup(String lookupName, String beanName, Class<?> beanInterface) {
        Object nameNormalized = lookupName;
        if (this.container == null) {
            if (!lookupName.startsWith("java:")) {
                nameNormalized = "java:comp/env/" + lookupName;
            }
        } else if (!lookupName.startsWith("java:global/")) {
            if (beanName == null) {
                String s = this.getJndiMapping().get(lookupName);
                if (s == null) {
                    s = this.getJndiMapping().get("java:comp/env/" + lookupName);
                }
                if (s == null) {
                    throw new RuntimeException(String.format("Lookup name (%s) does not start with %s, beanName is %s, and not in jndiMapping %s", lookupName, "java:global/", beanName, this.getJndiMapping()));
                }
                nameNormalized = s;
                Helper.getLogger().info("Retrieved the global jndi name from jndiMapping: " + lookupName + " : " + (String)nameNormalized);
            } else {
                nameNormalized = "java:global/ejbembed_vehicle_ejb/" + beanName;
                if (beanInterface != null) {
                    nameNormalized = (String)nameNormalized + "!" + beanInterface.getName();
                }
            }
        }
        try {
            return this.getContext().lookup((String)nameNormalized);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected File[] getAdditionalModules() {
        return this.additionalModules;
    }

    protected StringBuilder getReasonBuffer() {
        if (this.reasonBuffer == null) {
            this.reasonBuffer = new StringBuilder();
        }
        return this.reasonBuffer;
    }

    /*
     * WARNING - void declaration
     */
    protected void appendReason(Object ... oo) {
        for (Object object : oo) {
            void var5_5;
            if (object instanceof Collection) {
                ArrayList arrayList = new ArrayList((Collection)object);
            }
            this.getReasonBuffer().append(var5_5).append(System.getProperty("line.separator"));
        }
    }

    protected void assertEquals(String messagePrefix, Object expected, Object actual) throws RuntimeException {
        Helper.assertEquals(messagePrefix, expected, actual, this.getReasonBuffer());
    }

    protected void assertNotEquals(String messagePrefix, Object expected, Object actual) throws RuntimeException {
        Helper.assertNotEquals(messagePrefix, expected, actual, this.getReasonBuffer());
    }

    protected void assertGreaterThan(String messagePrefix, long arg1, long arg2) throws RuntimeException {
        Helper.assertGreaterThan(messagePrefix, arg1, arg2, this.getReasonBuffer());
    }

    private void nuke() {
        this.accessCount = 0;
        this.injectionSupported = null;
        this.status = null;
        this.reason = null;
        this.testName = null;
        this.inVehicle = false;
        this.reasonBuffer = null;
        this.moduleName = null;
        this.container = null;
        this.context = null;
        this.jndiMapping = null;
        this.additionalModules = null;
    }

    private void passOrFail(boolean passOrFail, String ... why) {
        this.status = (passOrFail ? "[TEST PASSED] " : "[TEST FAILED] ") + "testName=" + this.testName;
        this.appendReason(why);
        if (this.reasonBuffer != null) {
            this.reason = this.reasonBuffer.toString();
        }
        this.accessCount = (byte)(this.accessCount + 1);
    }
}

