/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.async.common.annotated;

import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.statussingleton.StatusSingletonBean;
import com.sun.ts.tests.ejb30.lite.async.common.annotated.AsyncIF;
import jakarta.annotation.Resource;
import jakarta.ejb.AsyncResult;
import jakarta.ejb.Asynchronous;
import jakarta.ejb.EJB;
import jakarta.ejb.SessionContext;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class AsyncBeanBase
implements AsyncIF {
    private boolean errorOccurredInInstance = false;
    @Resource
    protected SessionContext sessionContext;
    @EJB
    private StatusSingletonBean statusSingleton;

    @Override
    @Asynchronous
    public void addAway(int a, int b, int key) {
        this.statusSingleton.addResult(key, a + b + key);
    }

    @Override
    @Asynchronous
    public void voidRuntimeException(Integer key) throws RuntimeException {
        this.errorOccurredInInstance = true;
        this.statusSingleton.addResult(key, 1);
        throw new RuntimeException("voidRuntimeException in instance " + this);
    }

    @Override
    @Asynchronous
    public Future<Integer> addReturn(int a, int b) {
        return new AsyncResult((Object)(a + b));
    }

    @Override
    @Asynchronous
    public Future<Integer> futureRuntimeException() throws RuntimeException {
        this.errorOccurredInInstance = true;
        throw new RuntimeException("futureRuntimeException in instance " + this);
    }

    @Override
    @Asynchronous
    public Future<Integer> futureError() throws AssertionError {
        this.errorOccurredInInstance = true;
        throw new AssertionError((Object)("futureError in instance " + this));
    }

    @Override
    @Asynchronous
    public Future<Integer> futureException() throws CalculatorException {
        throw new CalculatorException("futureException in instance " + this);
    }

    @Override
    @Asynchronous
    public Future<Integer> identityHashCode() {
        return new AsyncResult((Object)System.identityHashCode(this));
    }

    @Override
    @Asynchronous
    public Future<Boolean> isErrorOccurredInInstance() {
        Helper.getLogger().logp(Level.FINE, "AsyncBeanBase", "isDestroyed", "instance: " + this + ", identityHashCode: " + System.identityHashCode(this) + "errorOccurredInInstance: " + this.errorOccurredInInstance);
        return new AsyncResult((Object)this.errorOccurredInInstance);
    }

    @Override
    @Asynchronous
    public Future<Boolean> cancelMayInterruptIfRunning() {
        Helper.getLogger().info(Helper.assertEquals("Check wasCancelCalled before any client cancel request", false, this.sessionContext.wasCancelCalled()));
        this.statusSingleton.addResult("CANCEL_IN_BEAN_KEY", "CANCEL_IN_BEAN_VAL");
        long stopTime = System.currentTimeMillis() + 60000L;
        while (!this.statusSingleton.isResultAvailable("CANCEL_IN_CLIENT_KEY") && System.currentTimeMillis() < stopTime) {
            Helper.busyWait(1000L);
        }
        if (!this.statusSingleton.isResultAvailable("CANCEL_IN_CLIENT_KEY")) {
            throw new RuntimeException("The client has not requested to cancel the async method after waiting millis 60000");
        }
        Helper.getLogger().info("The client has requested to cancel the async method.");
        return new AsyncResult((Object)this.sessionContext.wasCancelCalled());
    }

    @Override
    @Asynchronous
    public Future<List<String>> futureValueList(List<String> vals) {
        return new AsyncResult(vals);
    }

    @Override
    public void passByValueOrReference(String[] ss) {
        for (int i = 0; i < ss.length; ++i) {
            ss[i] = this.toString();
        }
    }

    @Override
    @Asynchronous
    public Future<String> passByValueOrReferenceAsync(String[] ss) {
        this.passByValueOrReference(ss);
        return new AsyncResult(null);
    }
}

