/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.interceptor.common.lifecycle;

import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.interceptor.ExcludeDefaultInterceptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Startup
@Singleton
@ExcludeDefaultInterceptors
public class HistorySingletonBean {
    private Map<Object, List<String>> postConstructRecordsMap = new HashMap<Object, List<String>>();
    private List<String> aroundInvokeRecords = new ArrayList<String>();

    public List<String> getPostConstructRecordsFor(Object beanInstance) {
        List<String> rec = this.postConstructRecordsMap.get(beanInstance);
        return Collections.unmodifiableList(rec);
    }

    public void addPostConstructRecordFor(Object beanInstance, String aEntry) {
        List<String> rec = this.postConstructRecordsMap.get(beanInstance);
        if (rec == null) {
            rec = new ArrayList<String>();
            this.postConstructRecordsMap.put(beanInstance, rec);
        }
        rec.add(aEntry);
    }

    public List<String> getAroundInvokeRecords() {
        return Collections.unmodifiableList(this.aroundInvokeRecords);
    }

    public void addAroundInvokeRecord(String aEntry) {
        this.aroundInvokeRecords.add(aEntry);
    }

    public void clearAroundInvokeRecords() {
        this.aroundInvokeRecords.clear();
    }

    public List<String> getAndClearAroundInvokeRecords() {
        ArrayList<String> result = new ArrayList<String>(this.aroundInvokeRecords);
        this.clearAroundInvokeRecords();
        return result;
    }
}

