/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.sameejbclass;

import com.sun.ts.lib.deliverable.cts.resource.Dog;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.misc.sameejbclass.SameEJBClassIF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;

public class SameEJBClassBean
implements SameEJBClassIF {
    @Resource(name="myChar")
    private Character myChar;
    private boolean myCharInjected;
    private String reason;

    @PostConstruct
    private void checkEnvEntry0() {
        Helper.getLogger().fine("In PostConstruct method of bean instance " + this);
        if (this.myChar != null) {
            if (this.myChar.charValue() == '1' || this.myChar.charValue() == '2' || this.myChar.charValue() == '3' || this.myChar.charValue() == '4') {
                this.myCharInjected = true;
                this.reason = "env-entry myChar has been correctly injected: " + this.myChar;
            } else {
                this.reason = "env-entry myChar has been incorrectly injected.  Expecting 1,2,3 or 4, but actual " + this.myChar;
            }
        } else {
            this.reason = "env-entry myChar has not been injected.";
        }
    }

    public Dog testDTO(int i, String s, Dog dog) {
        dog.setName(s);
        return dog;
    }

    public Dog testDTO(int i, String s, Object obj) {
        Dog dog = (Dog)obj;
        dog.setName(s);
        return dog;
    }

    @Override
    public String checkEnvEntry(String beanName) throws TestFailedException {
        Helper.getLogger().fine("Injected myChar=" + this.myChar + ", bean instance=" + this);
        if (this.myCharInjected) {
            return this.reason;
        }
        throw new TestFailedException("Inside " + beanName + ", " + this.reason);
    }
}

