/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.interceptor.aroundtimeout.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.interceptor.aroundtimeout.common.AroundTimeoutIF;
import jakarta.ejb.EJB;
import java.util.List;

public class JsfClientBase
extends com.sun.ts.tests.ejb30.timer.common.JsfClientBase {
    @EJB(beanName="AroundTimeoutBean")
    private AroundTimeoutIF aroundTimeoutBean;
    @EJB(beanName="AroundTimeoutOverrideBean")
    private AroundTimeoutIF aroundTimeoutOverrideBean;
    @EJB(beanName="AroundTimeoutComplementBean")
    private AroundTimeoutIF aroundTimeoutComplementBean;
    @EJB(beanName="InvocationContextMethodsBean")
    private AroundTimeoutIF invocationContextMethodsBean;
    @EJB(beanName="MethodOverrideBean")
    private AroundTimeoutIF methodOverrideBean;
    @EJB(beanName="MethodOverride2Bean")
    private AroundTimeoutIF methodOverride2Bean;

    protected AroundTimeoutIF getAroundTimeoutExceptionBean() {
        return null;
    }

    public void allInterceptors() {
        String[] expectedAroundTimeout = new String[]{"InterceptorBase", "Interceptor2", "InterceptorBase", "Interceptor1", "InterceptorBase", "Interceptor4", "InterceptorBase", "Interceptor3", "InterceptorBase", "Interceptor6", "InterceptorBase", "Interceptor5", "AroundTimeoutBeanBase", "AroundTimeoutBean", "AroundTimeoutBeanBase.timeout"};
        this.aroundTimeoutTest(this.aroundTimeoutBean, expectedAroundTimeout, true);
    }

    public void allInterceptorsOverride() {
        String[] expectedAroundTimeout = new String[]{"InterceptorBase", "Interceptor3", "InterceptorBase", "Interceptor4", "InterceptorBase", "Interceptor6", "InterceptorBase", "Interceptor5", "AroundTimeoutBeanBase", "AroundTimeoutOverrideBean", "AroundTimeoutBeanBase.timeout"};
        this.aroundTimeoutTest(this.aroundTimeoutOverrideBean, expectedAroundTimeout, true);
    }

    public void allInterceptorsComplement() {
        String[] expectedAroundTimeout = new String[]{"InterceptorBase", "Interceptor4", "InterceptorBase", "Interceptor3", "InterceptorBase", "Interceptor2", "InterceptorBase", "Interceptor1", "InterceptorBase", "Interceptor6", "InterceptorBase", "Interceptor5", "AroundTimeoutBeanBase", "AroundTimeoutComplementBean", "AroundTimeoutBeanBase.timeout"};
        this.aroundTimeoutTest(this.aroundTimeoutComplementBean, expectedAroundTimeout, true);
    }

    public void aroundTimeoutMethod() {
        String[] expectedAroundTimeout = new String[]{"InterceptorBase", "Interceptor2", "InterceptorBase", "Interceptor1", "MethodOverrideBean", "MethodOverrideBeanBase.timeout"};
        this.aroundTimeoutTest(this.methodOverrideBean, expectedAroundTimeout, true);
    }

    public void aroundTimeoutMethod2() {
        String[] expectedAroundTimeout = new String[]{"InterceptorBase", "Interceptor2", "InterceptorBase", "Interceptor1", "MethodOverrideBeanBase.timeout"};
        this.aroundTimeoutTest(this.methodOverride2Bean, expectedAroundTimeout, true);
    }

    public void aroundTimeoutException() {
        String[] expectedAroundTimeout = new String[]{"InterceptorBase", "Interceptor2", "InterceptorBase", "Interceptor1", "AroundTimeoutExceptionBeanBase", "RuntimeException"};
        this.aroundTimeoutTest(this.getAroundTimeoutExceptionBean(), expectedAroundTimeout, false);
    }

    public void invocationContextMethods() {
        String[] expectedAroundTimeout = new String[]{"InterceptorBase", "Interceptor6", "InterceptorBase", "Interceptor5", "getMethod", "getParameters", "getTarget", "getContextData", "setParameters", "AroundTimeoutBeanBase.timeout"};
        this.aroundTimeoutTest(this.invocationContextMethodsBean, expectedAroundTimeout, true);
    }

    protected String getAroundTimeoutRecordKey() {
        return this.getTestName() + ".around-timeout";
    }

    private void aroundTimeoutTest(AroundTimeoutIF b, String[] expectedAroundTimeout, boolean timeoutInvoked) {
        this.statusSingleton.removeRecords(this.getAroundTimeoutRecordKey());
        b.createSecondLaterTimer(this.getTestName(), 2);
        this.checkAndClearAroundTimeoutRecords(expectedAroundTimeout, this.getAroundTimeoutRecordKey(), timeoutInvoked);
    }

    private void checkAndClearAroundTimeoutRecords(String[] expected, String aroundTimeoutRecordKey, boolean timeoutInvoked) {
        if (timeoutInvoked) {
            this.passIfTimeout(new long[0]);
        } else {
            this.passIfNoTimeout(new long[0]);
        }
        List<String> records = this.statusSingleton.getRecords(aroundTimeoutRecordKey);
        this.statusSingleton.removeStatus(this.getTestName());
        this.statusSingleton.removeRecords(aroundTimeoutRecordKey);
        this.appendReason(Helper.compareResultList(expected, records));
    }
}

