/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.session.jspejbjdbc;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.integration.util.DBSupport;
import jakarta.ejb.EJBException;
import java.util.Properties;

public class TellerBean {
    private DBSupport DB;
    public String tellerName;

    public void initialize(String name, Properties p) {
        TestUtil.logTrace((String)"initialize");
        this.tellerName = name;
        try {
            TestUtil.logTrace((String)"initialize database support access object");
            this.DB = new DBSupport();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to initialize DB. Exception: " + e);
        }
        if (p != null) {
            try {
                TestUtil.logTrace((String)"initialize remote logging");
                TestUtil.init((Properties)p);
                this.DB.initDB(true, true);
            }
            catch (RemoteLoggingInitException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new EJBException(e.getMessage());
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new EJBException("unable to initialize DB table " + e);
            }
        }
    }

    public void transfer(int from, int to, double amt) {
        TestUtil.logTrace((String)"transfer");
        this.withdraw(from, amt);
        this.deposit(to, amt);
    }

    public double balance(int acct) {
        double balance;
        TestUtil.logTrace((String)"balance");
        try {
            balance = this.DB.balance(acct);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in balance: " + e);
        }
        return balance;
    }

    public double deposit(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"deposit");
        try {
            balance = this.DB.deposit(acct, amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in deposit: " + e);
        }
        return balance;
    }

    public double withdraw(int acct, double amt) {
        double balance;
        TestUtil.logTrace((String)"withdraw");
        try {
            balance = this.DB.withdraw(acct, amt);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in withdraw: " + e);
        }
        return balance;
    }

    public String getAllAccounts() {
        String accounts = null;
        try {
            accounts = this.DB.getAllAccounts();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Exception occurred in getAllAccounts: " + e);
        }
        return accounts;
    }

    public String sayHello() {
        return "Hello There World From TellerBean!!!";
    }
}

