/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet14;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class resultSetClient14
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet14";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private PreparedStatement pstmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private ResultSet oRes = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient14 theTests = new resultSetClient14();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort04() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort05() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Minimum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Minimum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetShort06() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort76() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sQuery = this.sqlp.getProperty("Smallint_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "Call to getShort is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort77() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sQuery = this.sqlp.getProperty("Smallint_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MinimumValue)");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Minimum Value", "Call to getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort78() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sQuery = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            ResultSetMetaData rsMetaData = this.oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            short oRetVal = this.oRes.getShort(sColName);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the value zero", "Call to getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort07() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Integer_Tab_Max_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            int oSuppVal = Integer.parseInt(sSuppVal);
            this.pstmt.setInt(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort08() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Integer_Tab_Min_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            int oSuppVal = Integer.parseInt(sSuppVal);
            this.pstmt.setInt(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Minimum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Minimum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetShort09() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort10() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Real_Tab_Max_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            float oSuppVal = Float.parseFloat(sSuppVal);
            this.pstmt.setFloat(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Real_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort11() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Real_Tab_Min_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            float oSuppVal = Float.parseFloat(sSuppVal);
            this.pstmt.setFloat(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Real_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Minimum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetShort12() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Real_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort16() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Float_Tab_Max_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            double oSuppVal = Double.parseDouble(sSuppVal);
            this.pstmt.setDouble(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Max", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Maximum value from the Insert String ");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Maximum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetShort17() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sUpdStmt = this.sqlp.getProperty("Float_Tab_Min_Update", "");
            this.pstmt = this.conn.prepareStatement(sUpdStmt);
            String sSuppVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            double oSuppVal = Double.parseDouble(sSuppVal);
            this.pstmt.setDouble(1, oSuppVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Min", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            short oExtVal = Short.parseShort(sExtVal);
            this.msg.addOutputMsg("" + oExtVal, "" + oRetVal);
            if (oRetVal == oExtVal) {
                this.msg.setMsg("getShort returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Minimum Value", "test getShort Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.pstmt.close();
                this.oRes.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void testGetShort18() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Null", "");
            this.oRes = this.stmt.executeQuery(sQuery);
            this.oRes.next();
            this.msg.setMsg("Calling ResultSet.getShort(NullValue)");
            this.msg.setMsg("get the Null value from the table using getShort Method");
            short oRetVal = this.oRes.getShort(1);
            if (oRetVal == 0) {
                this.msg.setMsg("Calling getShort method on a SQL Null column returns" + oRetVal);
            } else {
                this.msg.printTestError("getShort did not return the Value zero", "test getShort Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getShort is Failed!");
        }
        finally {
            try {
                this.oRes.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.stmt.close();
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

