/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.provider.jsonp;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;

@Path(value="resource")
public class Resource {
    public static final String[] LABEL = new String[]{"type", "number"};
    public static final String[] TYPE = new String[]{"home", "fax"};
    public static final String[] PHONE = new String[]{"212 555-1234", "646 555-4567"};

    @Path(value="tostructure")
    @GET
    public JsonStructure toStructure() {
        return this.toArray();
    }

    @Path(value="toarray")
    @GET
    public JsonArray toArray() {
        JsonArray array = Resource.createArray();
        return array;
    }

    @Path(value="toobject")
    @GET
    public JsonObject toObject() {
        return Resource.createObject(0);
    }

    @Path(value="fromobject")
    @POST
    public String fromObject(JsonObject object) {
        return object.toString();
    }

    @Path(value="fromarray")
    @POST
    public String fromArray(JsonArray array) {
        return array.toString();
    }

    @Path(value="fromstructure")
    @POST
    public String fromArray(JsonStructure struct) {
        return struct.toString();
    }

    public static JsonObject createObject(int id) {
        JsonObject object = Json.createObjectBuilder().add(LABEL[0], TYPE[id]).add(LABEL[1], PHONE[id]).build();
        return object;
    }

    public static JsonArray createArray() {
        JsonArray array = Json.createArrayBuilder().add((JsonValue)Resource.createObject(0)).add((JsonValue)Resource.createObject(1)).build();
        return array;
    }
}

