/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.xml;

import com.sun.ant.taskdefs.xml.AddProcessor;
import com.sun.ant.taskdefs.xml.ModifyProcessor;
import com.sun.ant.taskdefs.xml.NodeProcessorIntf;
import com.sun.ant.taskdefs.xml.ReadProcessor;
import com.sun.ant.taskdefs.xml.RemoveProcessor;
import com.sun.ant.taskdefs.xml.TaskDataIntf;
import com.sun.ant.taskdefs.xml.XMLFragment;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Text;

public abstract class BaseProcessor
implements NodeProcessorIntf {
    public static final String[] MODES = new String[]{"modified", "added", "removed", "read"};
    public static final int MODIFY = 0;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int READ = 3;
    protected int mode;
    protected List nodes;
    protected int numNodes;
    protected TaskDataIntf taskData;
    protected Project project;

    public static NodeProcessorIntf getProcessor(TaskDataIntf taskData) throws BuildException {
        String value = taskData.getValue();
        XMLFragment fragment = taskData.getFragment();
        boolean deletenodes = taskData.getDeletenodes();
        String property = taskData.getProperty();
        if (value != null && fragment == null && !deletenodes && property == null) {
            return new ModifyProcessor();
        }
        if (value == null && fragment != null && !deletenodes && property == null) {
            return new AddProcessor();
        }
        if (value == null && fragment == null && deletenodes && property == null) {
            return new RemoveProcessor();
        }
        if (value == null && fragment == null && !deletenodes && property != null) {
            return new ReadProcessor();
        }
        throw new BuildException("Error: a value attribute, a nested xmlfragment element must be specified or the deletenodes attribute must be set to true.");
    }

    public abstract void processElement(Element var1);

    public void processAttribute(Attribute attr) {
    }

    public void processText(Text text) {
    }

    public String getMessage() {
        return "Results written to \"" + this.taskData.getOutfile() + "\"";
    }

    public void fini() {
    }

    public String getModeStr() {
        return MODES[this.mode];
    }

    public int getMode() {
        return this.mode;
    }

    public void process(List nodes, TaskDataIntf taskData) {
        this.project = taskData.getProject();
        this.nodes = nodes;
        this.taskData = taskData;
        this.numNodes = nodes == null ? 0 : nodes.size();
        for (int i = 0; i < this.numNodes; ++i) {
            Object node = nodes.get(i);
            if (node instanceof Element) {
                this.processElement((Element)node);
                continue;
            }
            if (node instanceof Attribute) {
                this.processAttribute((Attribute)node);
                continue;
            }
            if (node instanceof Text) {
                this.processText((Text)node);
                continue;
            }
            this.project.log("Element is neither Element, Attribute nor Text node.", 1);
        }
        this.fini();
    }
}

