/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.client;

import java.net.URL;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.request.HttpExchange;
import servlet.tck.common.request.WebTestCase;

@ExtendWith(value={ArquillianExtension.class})
public abstract class BaseTckTest {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @ArquillianResource
    @OperateOnDeployment(value="_DEFAULT_")
    public URL url;
    public Properties _props;
    protected static final String UNAUTHORIZED = "401";
    protected static final String FORBIDDEN = "403";
    protected static final String NOT_FOUND = "404";
    protected static final String OK = "200";
    protected static final String CREATED = "201";
    protected static final String INTERNAL_SERVER_ERROR = "500";
    protected static final String SERVICE_UNAVAILABLE = "503";
    protected static final String CONTINUE = "100";
    protected static final String MOVED_TEMPORARY = "302";
    protected static final String GONE = "410";
    protected static final String LENGTH_REQUIRED = "411";
    protected static final String SERVLETHOSTPROP = "webServerHost";
    protected static final String SERVLETPORTPROP = "webServerPort";
    protected static final String TSHOME = "ts_home";
    protected static final ThreadLocal<Properties> TEST_PROPS = ThreadLocal.withInitial(Properties::new);
    protected static final String STATUS_CODE = "status-code";
    protected static final String REASON_PHRASE = "reason-phrase";
    protected static final String EXPECTED_HEADERS = "expected_headers";
    protected static final String UNEXPECTED_HEADERS = "unexpected_headers";
    protected static final String EXPECT_RESPONSE_BODY = "expect_response_body";
    protected static final String REQUEST = "request";
    protected static final String REQUEST_HEADERS = "request_headers";
    protected static final String SEARCH_STRING = "search_string";
    protected static final String SEARCH_STRING_IGNORE_CASE = "search_string_ignore_case";
    protected static final String BASIC_AUTH_USER = "basic_auth_user";
    protected static final String BASIC_AUTH_PASSWD = "basic_auth_passwd";
    protected static final String BASIC_AUTH_REALM = "basic_auth_realm";
    protected static final String UNAUTH_USERNAME = "authuser";
    protected static final String UNAUTH_PASSWORD = "authpassword";
    protected static final String USERNAME = "user";
    protected static final String PASSWORD = "password";
    protected static final String UNORDERED_SEARCH_STRING = "unordered_search_string";
    protected static final String CONTENT = "content";
    protected static final String TEST_NAME = "testname";
    protected static final String RESPONSE_MATCH = "response_match";
    protected static final String UNEXPECTED_RESPONSE_MATCH = "unexpected_response_match";
    protected static final String STANDARD = "standard";
    protected static final String IGNORE_BODY = "ignore_body";
    protected static final String STRATEGY = "strategy";
    protected String TESTDIR = null;
    protected String GOLDENFILEDIR = "/src/web";
    protected static final String GET = "GET ";
    protected static final String HTTP10 = " HTTP/1.0";
    protected static final String HTTP11 = " HTTP/1.1";
    protected static final String SL = "/";
    protected static final String GF_SUFFIX = ".gf";
    protected static final String JSP_SUFFIX = ".jsp";
    protected static final String USE_SAVED_STATE = "use_saved_state";
    protected static final String SAVE_STATE = "save_state";
    protected static final String IGNORE_STATUS_CODE = "ignore_status_code";
    protected String _testName = null;
    protected String _tsHome = null;
    protected String _contextRoot = null;
    protected String _generalURI = null;
    protected String _hostname = null;
    protected int _port = 0;
    protected WebTestCase _testCase = null;
    protected boolean _useSavedState = false;
    protected boolean _saveState = false;
    protected static final String FOLLOW_REDIRECT = "follow_redirect";
    protected boolean _redirect = false;

    public void setTestDir(String testDir) {
        this.TESTDIR = testDir;
    }

    public void setGeneralURI(String URI2) {
        this._generalURI = URI2;
    }

    public void setContextRoot(String root) {
        this._contextRoot = root;
    }

    public String getContextRoot() {
        return this._contextRoot;
    }

    public void setGoldenFileDir(String goldenDir) {
        this.GOLDENFILEDIR = goldenDir;
    }

    @BeforeEach
    public void setup() throws Exception {
        String ctxRoot = this.url.getPath();
        this.setContextRoot(ctxRoot.endsWith(SL) ? ctxRoot.substring(0, ctxRoot.length() - 1) : ctxRoot);
        Properties properties = new Properties();
        properties.put(SERVLETHOSTPROP, this.url.getHost());
        properties.put(SERVLETPORTPROP, Integer.toString(this.url.getPort()));
        properties.put(TSHOME, Paths.get("target/test-classes", new String[0]).toFile().getName());
        properties.setProperty("servlet_waittime", System.getProperty("servlet_waittime", "10"));
        properties.setProperty("servlet_async_wait", System.getProperty("servlet_async_wait", "4"));
        properties.setProperty("logical.hostname.servlet", System.getProperty("logical.hostname.servlet", "server"));
        properties.setProperty(USERNAME, System.getProperty(USERNAME, "j2ee"));
        properties.setProperty(PASSWORD, System.getProperty(PASSWORD, "j2ee"));
        properties.setProperty(BASIC_AUTH_PASSWD, System.getProperty(UNAUTH_PASSWORD, "j2ee"));
        properties.setProperty(BASIC_AUTH_USER, System.getProperty(BASIC_AUTH_USER, "j2ee"));
        properties.setProperty(BASIC_AUTH_PASSWD, System.getProperty(UNAUTH_PASSWORD, "j2ee"));
        properties.setProperty(UNAUTH_USERNAME, System.getProperty(UNAUTH_USERNAME, "javajoe"));
        properties.setProperty(UNAUTH_PASSWORD, System.getProperty(UNAUTH_PASSWORD, "javajoe"));
        this.setup(null, properties);
    }

    public void setup(String[] args, Properties p) throws Exception {
        this._props = p;
        String hostname = p.getProperty(SERVLETHOSTPROP).trim();
        String portnum = p.getProperty(SERVLETPORTPROP).trim();
        String tshome = p.getProperty(TSHOME).trim();
        if (this.isNullOrEmpty(hostname)) {
            throw new IllegalArgumentException("[BaseUrlClient] 'webServerHost' was not set in the ts.jte.");
        }
        this._hostname = hostname;
        if (this.isNullOrEmpty(portnum)) {
            throw new IllegalArgumentException("[BaseUrlClient] 'webServerPort' was not set in the ts.jte.");
        }
        this._port = Integer.parseInt(portnum);
        if (this.isNullOrEmpty(tshome)) {
            throw new IllegalArgumentException("[BaseUrlClient] 'tshome' was not set in the  ts.jte.");
        }
        this._tsHome = tshome;
        this.logger.debug("[BaseUrlClient] Test setup OK using properties {}", (Object)p);
    }

    public void cleanup() throws Exception {
        this.logger.info("[BaseUrlClient] Test cleanup OK");
    }

    protected void invoke() {
        try {
            this._testCase = new WebTestCase();
            this.setTestProperties(this._testCase);
            this.logger.trace("[BaseUrlClient] EXECUTING");
            if (this._useSavedState || this._saveState) {
                this._testCase.getRequest().setState(true);
            }
            if (this._redirect) {
                this.logger.trace("##########Call setFollowRedirects");
                this._testCase.getRequest().setFollowRedirects(this._redirect);
            }
            this._testCase.execute();
        }
        catch (Exception tfe) {
            Throwable t = tfe.getCause();
            if (t != null) {
                this.logger.warn("Root cause of Failure: " + t.getMessage(), t);
            }
            this.logger.error("Test: '" + this._testName + "' failed.", (Throwable)tfe);
            throw new RuntimeException("[BaseUrlClient] " + this._testName + " failed! Check output for cause of failure.", tfe);
        }
        finally {
            this._useSavedState = false;
            this._saveState = false;
            this._redirect = false;
            this.clearTestProperties();
        }
    }

    protected void setTestProperties(WebTestCase testCase) {
        HttpExchange req = testCase.getRequest();
        if (req == null) {
            String request = TEST_PROPS.get().getProperty(REQUEST);
            if (request.startsWith("GET") || request.startsWith("POST") || request.startsWith("OPTIONS") || request.startsWith("PUT") || request.startsWith("DELETE") || request.startsWith("HEAD") || request.endsWith(HTTP10) || request.endsWith(HTTP11)) {
                req = new HttpExchange(request, this._hostname, this._port);
                testCase.setRequest(req);
            } else {
                req = new HttpExchange(this.getTSRequest(request), this._hostname, this._port);
                testCase.setRequest(req);
            }
        }
        String key = null;
        String value = null;
        Enumeration<?> e = TEST_PROPS.get().propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            value = TEST_PROPS.get().getProperty(key);
            switch (key) {
                case "testname": {
                    testCase.setName(value);
                    this._testName = value;
                    break;
                }
                case "status-code": {
                    testCase.setExpectedStatusCode(value);
                    break;
                }
                case "ignore_status_code": {
                    testCase.setExpectedStatusCode("-1");
                    break;
                }
                case "reason-phrase": {
                    testCase.setExpectedReasonPhrase(value);
                    break;
                }
                case "expected_headers": {
                    testCase.addExpectedHeader(value);
                    break;
                }
                case "unexpected_headers": {
                    testCase.addUnexpectedHeader(value);
                    break;
                }
                case "search_string": {
                    testCase.setResponseSearchString(value);
                    break;
                }
                case "search_string_ignore_case": {
                    testCase.setResponseSearchStringIgnoreCase(value);
                    break;
                }
                case "strategy": {
                    testCase.setStrategy(value);
                    break;
                }
                case "content": {
                    req.setContent(value);
                    break;
                }
                case "response_match": {
                    break;
                }
                case "request_headers": {
                    req.addRequestHeader(TEST_PROPS.get().getProperty(key));
                    break;
                }
                case "expect_response_body": {
                    break;
                }
                case "unexpected_response_match": {
                    testCase.setUnexpectedResponseSearchString(value);
                    break;
                }
                case "unordered_search_string": {
                    testCase.setUnorderedSearchString(value);
                    break;
                }
                case "use_saved_state": {
                    this._useSavedState = true;
                    break;
                }
                case "save_state": {
                    this._saveState = true;
                    break;
                }
                case "follow_redirect": {
                    this.logger.debug("##########Found redirect Property");
                    this._redirect = true;
                    break;
                }
                case "basic_auth_user": 
                case "basic_auth_passwd": 
                case "basic_auth_realm": {
                    String user = TEST_PROPS.get().getProperty(BASIC_AUTH_USER);
                    String password = TEST_PROPS.get().getProperty(BASIC_AUTH_PASSWD);
                    String realm = TEST_PROPS.get().getProperty(BASIC_AUTH_REALM);
                    req.setAuthenticationCredentials(user, password, 1, realm);
                    break;
                }
            }
        }
    }

    private String getTSRequest(String request) {
        StringBuilder finReq = new StringBuilder(50);
        finReq.append(GET).append(this._contextRoot).append(SL).append(this._generalURI);
        finReq.append(SL).append(request).append(HTTP10);
        return finReq.toString();
    }

    private void clearTestProperties() {
        TEST_PROPS.get().clear();
    }

    private boolean isNullOrEmpty(String val) {
        return val == null || val.equals("");
    }

    public void logErr(String message) {
        this.logger.error(message);
    }

    public void logErr(String message, Exception e) {
        this.logger.error(message, (Throwable)e);
    }

    public void logMsg(String message) {
        this.logger.info(message);
    }

    public void logTrace(String message) {
        this.logger.trace(message);
    }
}

