/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.listeners;

import com.sun.ts.tests.jstl.common.JstlTckConstants;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public final class SQLContextListener
implements ServletContextListener,
JstlTckConstants {
    private ServletContext _context;
    private boolean _debug = true;

    public void contextInitialized(ServletContextEvent event) {
        this._context = event.getServletContext();
        Integer jstl_tab1_rows = new Integer(this._context.getInitParameter("JSTL_TAB1_ROWS"));
        this._context.setAttribute("JSTL_TAB1_ROWS", (Object)jstl_tab1_rows);
        Properties props = new Properties();
        this._context.setAttribute("sqlProps", (Object)props);
        try {
            this.trace("Loading sql.properties from URI: /WEB-INF/jstl-sql.properties");
            props.load(this._context.getResourceAsStream("/WEB-INF/jstl-sql.properties"));
            if (this._debug) {
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.trace(key + "=" + props.getProperty(key));
                }
            }
        }
        catch (IOException io) {
            this.trace("Unexpected IOException loading sql.properties from URI: /WEB-INF/jstl-sql.properties");
            this.trace("Exception received: " + io.toString());
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        this._context.removeAttribute("jstlDS");
        this.trace("Removed jstlDS from context.");
        this._context.removeAttribute("logDS");
        this.trace("Removed logDS from context.");
        this._context.removeAttribute("sqlProps");
        this.trace("Removed sqlProps from context.");
        this._context.removeAttribute("JSTL_TAB1_ROWS");
        this.trace("Removed JSTL_TAB1_ROWS from context.");
    }

    private void trace(String buf) {
        if (this._debug) {
            this._context.log("[SQLContextListener] " + buf);
        }
    }
}

