/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.tags;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TagSupport;
import jakarta.servlet.jsp.tagext.TryCatchFinally;

public class ExceptionCheckTag
extends TagSupport
implements TryCatchFinally {
    private static final int BUFFER_SIZE = 255;
    private String _exception = null;
    private String _rootException = null;
    private String _varName = null;
    private boolean _checkRootCause = false;
    private String _exceptionText = null;
    private boolean _exceptionCaught = false;
    private Exception _unexpectedException = null;

    public void setException(String exception) {
        this._exception = exception;
    }

    public void setRootException(String rootException) {
        this._rootException = rootException;
    }

    public void setVar(String var) {
        this._varName = var;
    }

    public void setCheckRootCause(String checkRootCause) {
        this._checkRootCause = Boolean.valueOf(checkRootCause);
    }

    public void setExceptionText(String exceptionText) {
        this._exceptionText = exceptionText.toLowerCase();
    }

    public int doStartTag() throws JspException {
        return 1;
    }

    public void doCatch(Throwable t) {
        StringBuffer sb;
        block18: {
            sb = new StringBuffer(255);
            try {
                Class<?> clazz = Class.forName(this._exception);
                if (clazz.isInstance(t)) {
                    block17: {
                        sb.append("The expected Exception <strong>");
                        sb.append(this._exception);
                        sb.append("</strong> was thrown!");
                        if (t instanceof JspException && this._checkRootCause) {
                            Throwable rt = ((JspException)t).getRootCause();
                            if (rt != null) {
                                if (this._rootException == null) {
                                    sb.append("<br>\nThe root cause of Exception defined");
                                } else {
                                    try {
                                        Class<?> root = Class.forName(this._rootException);
                                        if (root.isInstance(rt)) {
                                            sb.append("<br>\nThe root cause Exception <strong>");
                                            sb.append(this._rootException);
                                            sb.append("</strong> was of the expected type.");
                                            break block17;
                                        }
                                        sb.append("<br>\nThe root cause Exception <strong>");
                                        sb.append(this._rootException);
                                        sb.append("</strong> was not of the expected type.");
                                        sb.append("Exception type received:<strong>");
                                        sb.append(rt.getClass());
                                        sb.append("</strong>.<br>");
                                    }
                                    catch (Exception e) {
                                        sb.append("<strong>Error:</strong> The specified ");
                                        sb.append("Root Exception class <strong>");
                                        sb.append(this._rootException);
                                        sb.append("</strong> does not exist!");
                                    }
                                }
                            } else {
                                sb.append("<strong>Error:</strong>");
                                sb.append("The expected Exception <strong>");
                                sb.append(this._exception);
                                sb.append("</strong> was thrown but the ");
                                sb.append("root cause was not populated");
                            }
                        }
                    }
                    if (this._exceptionText != null) {
                        boolean found = false;
                        String toString = t.toString();
                        toString = toString != null ? toString.toLowerCase() : "";
                        String message = t.getMessage();
                        message = message != null ? message.toLowerCase() : "";
                        if (toString.indexOf(this._exceptionText) > -1) {
                            found = true;
                        } else if (message.indexOf(this._exceptionText) > -1) {
                            found = true;
                        }
                        if (found) {
                            sb.append("<br>\nThe expected Exception text");
                            sb.append(" was found in the Exception message!");
                        } else {
                            sb.append("<br>\n<strong>Error:</strong>");
                            sb.append("The expected Exception text <strong>");
                            sb.append(this._exceptionText);
                            sb.append("</strong> was not found in the Exception!");
                            sb.append("<br>\nThe exception text was: ");
                            sb.append("toString(): ");
                            sb.append(toString);
                            sb.append(" getMessage(): ");
                            sb.append(message);
                        }
                    }
                    break block18;
                }
                sb.append("<strong>Error:</strong> ");
                sb.append("The expected Exception <strong>");
                sb.append(this._exception);
                sb.append("</strong> was not thrown!<br>\n");
                sb.append("The actual Exception thrown was: <strong>");
                sb.append(t.getClass());
                sb.append("</strong>");
            }
            catch (Exception e) {
                sb.append("<strong>Error:</strong> The specified ");
                sb.append("Exception class <strong>");
                sb.append(this._exception);
                sb.append("</strong> does not exist!");
                e.printStackTrace();
            }
        }
        this.pageContext.setAttribute(this._varName, (Object)sb.toString());
    }

    public void doFinally() {
        if (this.pageContext.getAttribute(this._varName, 1) == null) {
            this.pageContext.setAttribute(this._varName, (Object)("<strong>Error: </strong>No Exception thrown!<br>\n The expected Exception was: <strong>" + this._exception + "</strong>"));
        }
    }

    public void release() {
        this._exception = null;
        this._unexpectedException = null;
        this._varName = null;
        this._exceptionCaught = false;
        this._checkRootCause = false;
        this._exceptionText = null;
        this._rootException = null;
    }
}

