/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.common.wrappers;

import jakarta.servlet.ServletContext;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class TckConnectionWrapper
implements Connection {
    private static final int GET_TX_ISOLATION = 0;
    private static final int SET_AUTOCOMMIT = 1;
    private static final int SET_TX_ISOLATION = 2;
    private static final int COMMIT_ROLLBACK = 3;
    private static final int RESET_TX_ISOLATION = 4;
    private static final int RESET_AUTOCOMMIT = 5;
    private static final int CLOSE_CONNECTION = 6;
    private static final int MAXLIFECYCLE_SIZE = 7;
    private ServletContext _context = null;
    private Connection _conn = null;
    private ArrayList _log = null;
    private int _autoCommitMode;
    private boolean _setIsolationLevel = false;
    private boolean _resetIsolationLevel = false;
    private int _newIsolationSetting = -1;

    public TckConnectionWrapper(ServletContext context, Connection conn) {
        this._context = context;
        this._conn = conn;
        this._log = new ArrayList(7);
        int i = 0;
        while (i < 7) {
            this._log.add(i, "");
            ++i;
        }
        this._setIsolationLevel = false;
        this._resetIsolationLevel = false;
        this._autoCommitMode = 1;
        int isoLevel = 0;
        try {
            isoLevel = conn.getTransactionIsolation();
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer newIsoLevel = (Integer)context.getAttribute("isoLevel");
        this._newIsolationSetting = newIsoLevel != null ? newIsoLevel : isoLevel;
    }

    public void clearWarnings() throws SQLException {
        this._conn.clearWarnings();
    }

    public void close() throws SQLException {
        this._log.set(6, "Connection.close()");
        ArrayList<String> lifeCycle = new ArrayList<String>();
        Iterator i = this._log.iterator();
        while (i.hasNext()) {
            String buf = (String)i.next();
            if (buf.equals("")) continue;
            lifeCycle.add(buf);
        }
        this._context.setAttribute("connLog", lifeCycle);
        this._conn.close();
    }

    public void commit() throws SQLException {
        this._log.set(3, "Connection.commit()");
        this._conn.commit();
    }

    public Statement createStatement() throws SQLException {
        return this._conn.createStatement();
    }

    public Statement createStatement(int param, int param1) throws SQLException {
        return this._conn.createStatement(param, param1);
    }

    public Statement createStatement(int param, int param1, int param2) throws SQLException {
        return this._conn.createStatement(param, param1, param2);
    }

    public boolean getAutoCommit() throws SQLException {
        return this._conn.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this._conn.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this._conn.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this._conn.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this._log.set(0, "Connection.getTransactionIsolation()");
        int isolationSetting = this._conn.getTransactionIsolation();
        if (isolationSetting == this._newIsolationSetting) {
            this.setTransactionIsolationSetting(2, this._newIsolationSetting);
            this.setTransactionIsolationSetting(4, this._newIsolationSetting);
            this._resetIsolationLevel = true;
            this._setIsolationLevel = true;
        }
        return isolationSetting;
    }

    public Map getTypeMap() throws SQLException {
        return this._conn.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._conn.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this._conn.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this._conn.isReadOnly();
    }

    public String nativeSQL(String str) throws SQLException {
        return this._conn.nativeSQL(str);
    }

    public CallableStatement prepareCall(String str) throws SQLException {
        return this._conn.prepareCall(str);
    }

    public CallableStatement prepareCall(String str, int param, int param2) throws SQLException {
        return this._conn.prepareCall(str, param, param2);
    }

    public CallableStatement prepareCall(String str, int param, int param2, int param3) throws SQLException {
        return this._conn.prepareCall(str, param, param2, param3);
    }

    public PreparedStatement prepareStatement(String str) throws SQLException {
        return this._conn.prepareStatement(str);
    }

    public PreparedStatement prepareStatement(String str, int param) throws SQLException {
        return this._conn.prepareStatement(str, param);
    }

    public PreparedStatement prepareStatement(String str, int[] values) throws SQLException {
        return this._conn.prepareStatement(str, values);
    }

    public PreparedStatement prepareStatement(String str, String[] str1) throws SQLException {
        return this._conn.prepareStatement(str, str1);
    }

    public PreparedStatement prepareStatement(String str, int param, int param2) throws SQLException {
        return this._conn.prepareStatement(str, param, param2);
    }

    public PreparedStatement prepareStatement(String str, int param, int param2, int param3) throws SQLException {
        return this._conn.prepareStatement(str, param, param2, param3);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this._conn.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this._log.set(3, "Connection.rollback()");
        this._conn.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this._conn.rollback(savepoint);
    }

    public void setAutoCommit(boolean param) throws SQLException {
        this._log.set(this._autoCommitMode, "Connection.setAutoCommit(" + param + ")");
        this._conn.setAutoCommit(param);
        this._autoCommitMode = 5;
    }

    public void setCatalog(String str) throws SQLException {
        this._conn.setCatalog(str);
    }

    public void setHoldability(int param) throws SQLException {
        this._conn.setHoldability(param);
    }

    public void setReadOnly(boolean param) throws SQLException {
        this._conn.setReadOnly(param);
    }

    public Savepoint setSavepoint() throws SQLException {
        return this._conn.setSavepoint();
    }

    public Savepoint setSavepoint(String str) throws SQLException {
        return this._conn.setSavepoint(str);
    }

    public void setTransactionIsolation(int param) throws SQLException {
        if (!this._setIsolationLevel) {
            this.setTransactionIsolationSetting(2, param);
            this._setIsolationLevel = true;
        } else if (!this._resetIsolationLevel) {
            this.setTransactionIsolationSetting(4, param);
            this._resetIsolationLevel = true;
        }
        this._conn.setTransactionIsolation(param);
    }

    public void setTypeMap(Map map) throws SQLException {
        this._conn.setTypeMap(map);
    }

    private void setTransactionIsolationSetting(int slot, int param) {
        String isolationLevel = null;
        switch (param) {
            case 1: {
                isolationLevel = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 2: {
                isolationLevel = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 4: {
                isolationLevel = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                isolationLevel = "TRANSACTION_SERIALIZABLE";
            }
        }
        if (slot == 4) {
            isolationLevel = "";
        }
        this._log.set(slot, "Connection.setTransactionIsolation(" + isolationLevel + ")");
    }

    static {
        GET_TX_ISOLATION = 0;
        SET_AUTOCOMMIT = 1;
        SET_TX_ISOLATION = 2;
        COMMIT_ROLLBACK = 3;
        RESET_TX_ISOLATION = 4;
        RESET_AUTOCOMMIT = 5;
        CLOSE_CONNECTION = 6;
        MAXLIFECYCLE_SIZE = 7;
    }
}

