/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.january.MetadataException;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.metadata.IMetadata;

public class Metadata
implements IMetadata {
    private static final long serialVersionUID = 8640458661665962384L;
    private Map<String, ? extends Serializable> metadata;
    private Map<String, int[]> shapes = new LinkedHashMap<String, int[]>(7);
    private Collection<Serializable> userObjects;
    private String filePath;

    public Metadata() {
    }

    public Metadata(Map<String, ? extends Serializable> metadata) {
        this.initialize(metadata);
    }

    @Override
    public void initialize(Map<String, ? extends Serializable> metadata) {
        this.metadata = metadata;
    }

    @Override
    public void addNames(Collection<String> names) {
        if (names != null) {
            for (String n : names) {
                this.shapes.put(n, null);
            }
        }
    }

    @Override
    public void setMetadata(Map<String, ? extends Serializable> metadata) {
        this.metadata = metadata;
    }

    protected Map<String, ? extends Serializable> getInternalMetadata() {
        return this.metadata;
    }

    public void setUserObjects(Collection<Serializable> objects) {
        this.userObjects = objects;
    }

    @Override
    public void addDataInfo(String name, int ... shape) {
        this.shapes.put(name, shape);
    }

    @Override
    public Collection<String> getDataNames() {
        return Collections.unmodifiableCollection(this.shapes.keySet());
    }

    @Override
    public Map<String, int[]> getDataShapes() {
        return Collections.unmodifiableMap(this.shapes);
    }

    @Override
    public Map<String, Integer> getDataSizes() {
        HashMap<String, Integer> sizes = new HashMap<String, Integer>(1);
        for (Map.Entry<String, int[]> e : this.shapes.entrySet()) {
            int[] shape = e.getValue();
            if (shape != null && shape.length > 1) {
                sizes.put(e.getKey(), ShapeUtils.calcSize(shape));
                continue;
            }
            sizes.put(e.getKey(), null);
        }
        if (sizes.size() > 0) {
            return Collections.unmodifiableMap(sizes);
        }
        return null;
    }

    @Override
    public Serializable getMetaValue(String key) throws MetadataException {
        return this.metadata == null ? null : this.metadata.get(key);
    }

    @Override
    public Collection<String> getMetaNames() throws MetadataException {
        return this.metadata == null ? Collections.EMPTY_SET : Collections.unmodifiableCollection(this.metadata.keySet());
    }

    @Override
    public Collection<Serializable> getUserObjects() {
        return this.userObjects;
    }

    @Override
    public IMetadata clone() {
        Metadata c;
        block26: {
            c = null;
            try {
                c = (Metadata)super.clone();
                if (this.metadata != null) {
                    HashMap<String, ? extends Serializable> md = new HashMap<String, Serializable>();
                    c.metadata = md;
                    ByteArrayOutputStream os = new ByteArrayOutputStream(512);
                    for (String k : this.metadata.keySet()) {
                        Serializable v = this.metadata.get(k);
                        if (v != null) {
                            Throwable throwable = null;
                            Object var8_10 = null;
                            try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                                oos.writeObject(v);
                                Throwable throwable2 = null;
                                Object var11_15 = null;
                                try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));){
                                    Serializable nv = (Serializable)ois.readObject();
                                    md.put(k, nv);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                            os.reset();
                            continue;
                        }
                        md.put(k, null);
                    }
                }
                c.shapes = new HashMap<String, int[]>(1);
                for (Map.Entry<String, int[]> e : this.shapes.entrySet()) {
                    int[] s = e.getValue();
                    c.shapes.put(e.getKey(), s == null ? null : (int[])s.clone());
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            catch (Throwable e) {
                boolean cfr_ignored_0 = e instanceof ClassNotFoundException;
                if (!(e instanceof RuntimeException)) break block26;
                throw (RuntimeException)e;
            }
        }
        return c;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

