/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.IDynamicDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;

public class SliceND {
    private int[] lstart;
    private int[] lstop;
    private int[] lstep;
    private transient int[] lshape;
    private int[] oshape;
    private int[] mshape;
    private boolean expanded;

    private static int[] copy(int[] in) {
        return in == null ? null : (int[])in.clone();
    }

    public SliceND(int[] shape) {
        int rank = shape == null ? 0 : shape.length;
        this.lstart = new int[rank];
        this.lstop = SliceND.copy(shape);
        this.lstep = new int[rank];
        Arrays.fill(this.lstep, 1);
        this.lshape = SliceND.copy(shape);
        this.oshape = SliceND.copy(shape);
        this.mshape = this.oshape;
        this.expanded = false;
    }

    public SliceND(int[] shape, Slice ... slice) {
        this(shape, (int[])null, slice);
    }

    public SliceND(int[] shape, int[] maxShape, Slice ... slice) {
        this(shape);
        if (maxShape != null) {
            this.initMaxShape(maxShape);
        }
        if (slice != null) {
            int length = slice.length;
            int rank = shape.length;
            if (length > rank) {
                throw new IllegalArgumentException("More slices have been specified than rank of shape");
            }
            int i = 0;
            while (i < length) {
                Slice s = slice[i];
                if (s != null) {
                    this.setSlice(i, s);
                }
                ++i;
            }
        }
    }

    private void initMaxShape(int[] maxShape) {
        int rank = this.oshape.length;
        if (maxShape.length != rank) {
            throw new IllegalArgumentException("Maximum shape must have same rank as shape");
        }
        this.mshape = (int[])maxShape.clone();
        int i = 0;
        while (i < rank) {
            int m = this.mshape[i];
            if (m != -1 && m < this.oshape[i]) {
                throw new IllegalArgumentException("Maximum shape must be greater than or equal to shape");
            }
            ++i;
        }
    }

    public SliceND(int[] shape, int[] start, int[] stop, int[] step) {
        this(shape, null, start, stop, step);
    }

    public SliceND(int[] shape, int[] maxShape, int[] start, int[] stop, int[] step) {
        int rank = shape == null ? 0 : shape.length;
        this.lstart = start == null ? new int[rank] : (int[])start.clone();
        this.lstop = stop == null ? new int[rank] : (int[])stop.clone();
        if (step == null) {
            this.lstep = new int[rank];
            Arrays.fill(this.lstep, 1);
        } else {
            this.lstep = (int[])step.clone();
        }
        if (this.lstart.length != rank || this.lstop.length != rank || this.lstep.length != rank) {
            throw new IllegalArgumentException("No of indexes does not match data dimensions: you passed it start=" + this.lstart.length + ", stop=" + this.lstop.length + ", step=" + this.lstep.length + ", and it needs " + rank);
        }
        this.lshape = new int[rank];
        this.oshape = SliceND.copy(shape);
        if (maxShape == null) {
            this.mshape = this.oshape;
        } else {
            this.initMaxShape(maxShape);
        }
        int i = 0;
        while (i < rank) {
            this.internalSetSlice(i, start == null ? null : Integer.valueOf(this.lstart[i]), stop == null ? null : Integer.valueOf(this.lstop[i]), this.lstep[i]);
            ++i;
        }
    }

    public void setSlice(int i, Integer start, Integer stop, int step) {
        this.internalSetSlice(i, start, stop, step);
    }

    public void setSlice(int i, int start, int stop, int step) {
        this.internalSetSlice(i, start, stop, step);
    }

    public void setSlice(int i, Slice slice) {
        this.internalSetSlice(i, slice.getStart(), slice.getStop(), slice.getStep());
    }

    private void internalSetSlice(int i, Integer start, Integer stop, int step) {
        if (this.oshape == null) {
            throw new IllegalArgumentException("Cannot set slice on null dataset");
        }
        if (step == 0) {
            throw new IllegalArgumentException("Step size must not be zero");
        }
        i = ShapeUtils.checkAxis(this.oshape.length, i);
        int s = this.oshape[i];
        int m = this.mshape[i];
        if (start == null) {
            start = step > 0 ? 0 : s - 1;
        } else if (start < 0) {
            start = start + s;
        }
        if (step > 0) {
            if (start < 0) {
                start = 0;
            } else if (start > s) {
                if (m == s) {
                    start = s;
                } else if (m != -1 && start > m) {
                    start = m;
                }
            }
            if (stop == null) {
                if (start >= s && m == -1) {
                    throw new IllegalArgumentException("To extend past current dimension in unlimited case, a stop value must be specified");
                }
                stop = s;
            } else if (stop < 0) {
                stop = stop + s;
            }
            if (stop < 0) {
                stop = 0;
            } else if (stop > s) {
                if (m == s) {
                    stop = s;
                } else if (m != -1 && stop > m) {
                    stop = m;
                }
            }
            if (start >= stop) {
                if (start < s || m == s) {
                    this.lstop[i] = start;
                } else {
                    stop = start + step;
                    if (m != -1 && stop > m) {
                        stop = m;
                    }
                    this.lstop[i] = stop;
                }
            } else {
                this.lstop[i] = stop;
            }
            if (this.lstop[i] > s) {
                this.oshape[i] = this.lstop[i];
                this.expanded = true;
            }
        } else {
            if (start < 0) {
                start = -1;
            } else if (start >= s) {
                start = s - 1;
            }
            if (stop == null) {
                stop = -1;
            } else if (stop < 0) {
                stop = stop + s;
            }
            if (stop < -1) {
                stop = -1;
            } else if (stop >= s) {
                stop = s - 1;
            }
            this.lstop[i] = stop >= start ? start.intValue() : stop.intValue();
        }
        stop = this.lstop[i];
        this.lshape[i] = SliceND.calcLength(start, stop, step);
        this.lstart[i] = start;
        this.lstep[i] = step;
    }

    private static int calcLength(int start, int stop, int step) {
        int l = start == stop ? 0 : (step > 0 ? Math.max(0, (stop - start - 1) / step + 1) : Math.max(0, (stop - start + 1) / step + 1));
        return l;
    }

    public int[] getSourceShape() {
        return this.oshape;
    }

    public int[] getMaxShape() {
        return this.mshape;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public int[] getShape() {
        return this.lshape;
    }

    public int[] getStart() {
        return this.lstart;
    }

    public int[] getStop() {
        return this.lstop;
    }

    public int[] getStep() {
        return this.lstep;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSourceShape(int ... shape) {
        if (shape != null) {
            if (this.oshape == null) throw new IllegalArgumentException("Cannot update null source shape with non-null");
            if (shape.length != this.oshape.length) {
                throw new IllegalArgumentException("Updated source shape must have same rank");
            }
            int i = 0;
            while (i < shape.length) {
                int s = shape[i];
                if (!(s <= 1 && s >= this.lshape[i] || SliceND.isSliceWithinShape(s, this.lstart[i], this.lstop[i], this.lstep[i]))) {
                    throw new IllegalArgumentException("Updated source shape must be outside latest slice");
                }
                ++i;
            }
            System.arraycopy(shape, 0, this.oshape, 0, shape.length);
            return;
        } else {
            if (this.oshape == null) return;
            throw new IllegalArgumentException("Cannot update non-null source shape with null");
        }
    }

    static boolean isSliceWithinShape(int l, int b, int e, int d) {
        if (l == 0) {
            return b == 0 && e == 0;
        }
        if (d > 0) {
            return b >= 0 && b <= e && b < l && e <= l;
        }
        return b >= 0 && b >= e && b < l && e >= -1;
    }

    public boolean isAll() {
        boolean allData;
        if (this.expanded) {
            return false;
        }
        if (this.oshape == null) {
            return true;
        }
        boolean bl = allData = Arrays.equals(this.oshape, this.lshape) && ShapeUtils.calcSize(this.oshape) > 0;
        if (allData) {
            int i = 0;
            while (i < this.lshape.length) {
                if (this.lstep[i] < 0) {
                    allData = false;
                    break;
                }
                ++i;
            }
        }
        return allData;
    }

    public SliceND flip(int i) {
        if (this.lshape == null) {
            return this;
        }
        i = ShapeUtils.checkAxis(this.lshape.length, i);
        int beg = this.lstart[i];
        int end = this.lstop[i];
        int step = this.lstep[i];
        int del = this.lstep[i] > 0 ? 1 : -1;
        int num = (end - beg - del) / step + 1;
        this.lstart[i] = beg + (num - 1) * step;
        this.lstop[i] = Math.max(beg - step, -1);
        this.lstep[i] = -step;
        return this;
    }

    public SliceND flip() {
        if (this.lshape == null) {
            return this;
        }
        int orank = this.lshape.length;
        int i = 0;
        while (i < orank) {
            this.flip(i);
            ++i;
        }
        return this;
    }

    public Slice[] convertToSlice() {
        if (this.lshape == null) {
            return null;
        }
        int orank = this.lshape.length;
        Slice[] slice = new Slice[orank];
        int j = 0;
        while (j < orank) {
            slice[j] = new Slice(this.lstart[j], this.lstop[j], this.lstep[j]);
            ++j;
        }
        return slice;
    }

    public SliceND clone() {
        SliceND c = new SliceND(this.oshape);
        if (this.lshape != null) {
            int i = 0;
            while (i < this.lshape.length) {
                c.lstart[i] = this.lstart[i];
                c.lstop[i] = this.lstop[i];
                c.lstep[i] = this.lstep[i];
                c.lshape[i] = this.lshape[i];
                ++i;
            }
        }
        c.expanded = this.expanded;
        return c;
    }

    public String toString() {
        int rank;
        int n = rank = this.lshape == null ? 0 : this.lshape.length;
        if (rank == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < rank) {
            Slice.appendSliceToString(s, this.oshape[i], this.lstart[i], this.lstop[i], this.lstep[i]);
            s.append(',');
            ++i;
        }
        return s.substring(0, s.length() - 1);
    }

    public static SliceND createSlice(ILazyDataset data, int[] start, int[] stop) {
        return SliceND.createSlice(data, start, stop, null);
    }

    public static SliceND createSlice(ILazyDataset data, int[] start, int[] stop, int[] step) {
        if (data instanceof IDynamicDataset) {
            return new SliceND(data.getShape(), ((IDynamicDataset)data).getMaxShape(), start, stop, step);
        }
        return new SliceND(data.getShape(), start, stop, step);
    }

    static SliceND createSlice(int[] shape, int[] maxShape, int[] start, int[] stop, int[] step) {
        if (shape == null) {
            throw new IllegalArgumentException("Shape must not be null");
        }
        int rank = shape.length;
        if (maxShape != null && maxShape.length != rank) {
            throw new IllegalArgumentException("Max shape must have same rank as shape");
        }
        if (start.length != rank || stop.length != rank || step.length != rank) {
            throw new IllegalArgumentException("No of indexes does not match data dimensions: you passed it start=" + start.length + ", stop=" + stop.length + ", step=" + step.length + ", and it needs " + rank);
        }
        SliceND s = new SliceND(shape);
        if (maxShape != null) {
            s.initMaxShape(maxShape);
        }
        s.lstart = start;
        s.lstop = stop;
        s.lstep = step;
        int i = 0;
        while (i < rank) {
            int e = stop[i];
            s.lshape[i] = SliceND.calcLength(start[i], e, step[i]);
            if (e > shape[i]) {
                s.oshape[i] = e;
                s.expanded = true;
            }
            ++i;
        }
        return s;
    }

    public void checkShapes(int[] dShape, int[] dMShape) {
        if (this.oshape == null) {
            if (dShape == null) {
                return;
            }
            throw new IllegalArgumentException("Dataset shape must be null with source shape null");
        }
        int r = this.oshape.length;
        if (r != dShape.length) {
            throw new IllegalArgumentException("Dataset shape must be equal in length to source shape");
        }
        if (Arrays.equals(this.oshape, dShape)) {
            return;
        }
        if (dMShape == null) {
            int i = 0;
            while (i < r) {
                int o = this.oshape[i];
                if (o == 0) {
                    throw new IllegalArgumentException("Slice shape has zero length");
                }
                if (o > dShape[i]) {
                    throw new IllegalArgumentException("Slice shape is greater than dataset shape");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < r) {
                int o = this.oshape[i];
                if (o == 0) {
                    throw new IllegalArgumentException("Slice shape has zero length");
                }
                int m = dMShape[i];
                if (m != -1 && o > m) {
                    throw new IllegalArgumentException("Slice shape is greater than max dataset shape");
                }
                ++i;
            }
        }
    }
}

