/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.Format;
import java.util.Arrays;
import java.util.List;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.MetadataException;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Comparisons;
import org.eclipse.january.dataset.ContiguousIterator;
import org.eclipse.january.dataset.ContiguousIteratorWithPosition;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.NullIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.SingleItemIterator;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.dataset.Stats;
import org.eclipse.january.dataset.StrideIterator;
import org.eclipse.january.metadata.ErrorMetadata;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.StatisticsMetadata;
import org.eclipse.january.metadata.internal.ErrorMetadataImpl;
import org.eclipse.january.metadata.internal.StatisticsMetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataset
extends LazyDatasetBase
implements Dataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataset.class);
    protected int size;
    protected transient AbstractDataset base;
    protected int[] stride;
    protected int offset;
    protected Serializable odata = null;
    protected Format stringFormat = null;
    protected static final char BLOCK_OPEN = '[';
    protected static final char BLOCK_CLOSE = ']';
    protected static final String ELLIPSIS = "...";
    private static int maxStringLength = 120;
    private static final int MAX_SUBBLOCKS = 6;
    private static final String SEPARATOR = ",";
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";

    protected abstract void setData();

    @Override
    public synchronized Dataset synchronizedCopy() {
        return this.clone();
    }

    @Override
    public Class<?> getElementClass() {
        return InterfaceUtils.getElementClass(this.getClass());
    }

    @Override
    public int getDType() {
        return DTypeUtils.getDType(this.getClass());
    }

    @Override
    public int hashCode() {
        return this.getStats().getHash(this.shape);
    }

    @Override
    public abstract AbstractDataset clone();

    @Override
    public void setStringFormat(Format format) {
        this.stringFormat = format;
    }

    @Override
    public Dataset copy(int dtype) {
        return this.copy(DTypeUtils.getInterface(dtype));
    }

    @Override
    public <T extends Dataset> T copy(Class<T> clazz) {
        return DatasetUtils.copy(clazz, this);
    }

    @Override
    public Dataset cast(int dtype) {
        return this.cast(DTypeUtils.getInterface(dtype));
    }

    @Override
    public <T extends Dataset> T cast(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        return DatasetUtils.cast(clazz, (IDataset)this);
    }

    @Override
    public <T extends Dataset> T cast(int isize, Class<T> clazz, boolean repeat) {
        if (clazz.isInstance(this) && this.getElementsPerItem() == isize) {
            return (T)this;
        }
        return DatasetUtils.cast(isize, clazz, (IDataset)this, repeat);
    }

    @Override
    public Dataset cast(boolean repeat, int dtype, int isize) {
        return this.cast(isize, DTypeUtils.getInterface(dtype), repeat);
    }

    @Override
    public abstract AbstractDataset getView(boolean var1);

    protected static void copyToView(Dataset orig, AbstractDataset view, boolean clone, boolean cloneMetadata) {
        int[] s;
        view.name = orig.getName();
        view.size = orig.getSize();
        view.odata = orig.getBuffer();
        view.offset = orig.getOffset();
        AbstractDataset a = orig instanceof AbstractDataset ? (AbstractDataset)orig : null;
        view.base = a == null ? null : a.base;
        int[] nArray = s = a == null ? null : a.stride;
        if (clone) {
            view.shape = orig.getShapeRef() == null ? null : orig.getShape();
            view.stride = s == null ? null : (int[])s.clone();
        } else {
            view.shape = orig.getShapeRef();
            view.stride = s;
        }
        view.metadata = AbstractDataset.getMetadataMap(orig, cloneMetadata);
        Class<? extends Dataset> oc = InterfaceUtils.findSubInterface(orig.getClass());
        Class<? extends Dataset> vc = InterfaceUtils.findSubInterface(view.getClass());
        if (!oc.equals(vc)) {
            view.setDirty();
        }
    }

    @Override
    public IntegerDataset getIndices() {
        IntegerDataset ret = DatasetUtils.indices(this.shape);
        if (this.getName() != null) {
            ret.setName("Indices of " + this.getName());
        }
        return ret;
    }

    @Override
    public Dataset getTransposedView(int ... axes) {
        axes = AbstractDataset.checkPermutatedAxes(this.shape, axes);
        AbstractDataset t = this.getView(true);
        if (axes == null || this.getRank() == 1) {
            return t;
        }
        int rank = this.shape.length;
        int[] tstride = new int[rank];
        int[] toffset = new int[1];
        int[] nshape = AbstractDataset.createStrides(new SliceND(this.shape), this, tstride, toffset);
        int[] nstride = new int[rank];
        int i = 0;
        while (i < rank) {
            int ax = axes[i];
            nstride[i] = tstride[ax];
            nshape[i] = this.shape[ax];
            ++i;
        }
        t.shape = nshape;
        t.stride = nstride;
        t.offset = toffset[0];
        t.base = this;
        t.setDirty();
        t.transposeMetadata(axes);
        return t;
    }

    @Override
    public Dataset transpose(int ... axes) {
        Dataset t = this.getTransposedView(axes);
        return t == null ? this.clone() : t.clone();
    }

    @Override
    public Dataset swapAxes(int axis1, int axis2) {
        int rank = this.shape.length;
        axis1 = ShapeUtils.checkAxis(rank, axis1);
        axis2 = ShapeUtils.checkAxis(rank, axis2);
        if (rank == 1 || axis1 == axis2) {
            return this;
        }
        int[] axes = new int[rank];
        int i = 0;
        while (i < rank) {
            axes[i] = i;
            ++i;
        }
        axes[axis1] = axis2;
        axes[axis2] = axis1;
        return this.getTransposedView(axes);
    }

    boolean isContiguous() {
        if (this.stride == null) {
            return true;
        }
        if (this.offset != 0) {
            return false;
        }
        int s = this.getElementsPerItem();
        int j = this.getRank() - 1;
        while (j >= 0) {
            if (this.stride[j] != s) {
                return false;
            }
            s *= this.shape[j];
            --j;
        }
        return true;
    }

    @Override
    public Dataset flatten() {
        if (!this.isContiguous()) {
            return this.clone().flatten();
        }
        return this.reshape(this.size);
    }

    protected void fillData(Object obj, int depth, int[] pos) {
        if (obj == null) {
            Class<?> c = InterfaceUtils.getElementClass(this.getClass());
            if (Float.class.equals(c)) {
                this.set((Object)Float.valueOf(Float.NaN), pos);
            } else if (Float.class.equals(c)) {
                this.set((Object)Double.NaN, pos);
            }
            return;
        }
        Class<?> clazz = obj.getClass();
        if (obj instanceof List) {
            List jl = (List)obj;
            int l = jl.size();
            int i = 0;
            while (i < l) {
                Object lo = jl.get(i);
                this.fillData(lo, depth + 1, pos);
                int n = depth;
                pos[n] = pos[n] + 1;
                ++i;
            }
            pos[depth] = 0;
        } else if (clazz.isArray()) {
            int l = Array.getLength(obj);
            if (clazz.equals(this.odata.getClass())) {
                System.arraycopy(obj, 0, this.odata, this.get1DIndex(pos), l);
            } else if (clazz.getComponentType().isPrimitive()) {
                int i = 0;
                while (i < l) {
                    this.set(Array.get(obj, i), pos);
                    int n = depth;
                    pos[n] = pos[n] + 1;
                    ++i;
                }
                pos[depth] = 0;
            } else {
                int i = 0;
                while (i < l) {
                    this.fillData(Array.get(obj, i), depth + 1, pos);
                    int n = depth;
                    pos[n] = pos[n] + 1;
                    ++i;
                }
                pos[depth] = 0;
            }
        } else if (obj instanceof IDataset) {
            boolean[] a = new boolean[this.shape.length];
            Arrays.fill(a, depth, a.length, true);
            this.setSlice(obj, this.getSliceIteratorFromAxes(pos, a));
        } else {
            this.set(obj, pos);
        }
    }

    @Override
    public IndexIterator getIterator(boolean withPosition) {
        if (this.stride != null) {
            return this.base.getSize() == 1 ? (withPosition ? new PositionIterator(this.offset, this.shape) : new SingleItemIterator(this.offset, this.size)) : new StrideIterator(this.shape, this.stride, this.offset);
        }
        if (this.shape == null) {
            return new NullIterator();
        }
        return withPosition ? new ContiguousIteratorWithPosition(this.shape, this.size) : new ContiguousIterator(this.size);
    }

    @Override
    public IndexIterator getIterator() {
        return this.getIterator(false);
    }

    @Override
    public PositionIterator getPositionIterator(int ... axes) {
        return new PositionIterator(this.shape, axes);
    }

    @Override
    public IndexIterator getSliceIterator(int[] start, int[] stop, int[] step) {
        return this.internalGetSliceIterator(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public IndexIterator getSliceIterator(SliceND slice) {
        if (slice != null) {
            this.checkSliceND(slice);
        }
        return this.internalGetSliceIterator(slice);
    }

    protected IndexIterator internalGetSliceIterator(SliceND slice) {
        if (ShapeUtils.calcLongSize(slice.getShape()) == 0L) {
            return new NullIterator(this.shape, slice.getShape());
        }
        if (this.stride != null) {
            return new StrideIterator(this.getElementsPerItem(), this.shape, this.stride, this.offset, slice);
        }
        return new SliceIterator(this.shape, this.size, slice);
    }

    @Override
    public SliceIterator getSliceIteratorFromAxes(int[] pos, boolean[] axes) {
        int[] start;
        int rank = this.shape.length;
        int[] stop = new int[rank];
        int[] step = new int[rank];
        if (pos == null) {
            start = new int[rank];
        } else if (pos.length == rank) {
            start = (int[])pos.clone();
        } else {
            throw new IllegalArgumentException("pos array length is not equal to rank of dataset");
        }
        if (axes == null) {
            axes = new boolean[rank];
            Arrays.fill(axes, true);
        } else if (axes.length != rank) {
            throw new IllegalArgumentException("axes array length is not equal to rank of dataset");
        }
        int i = 0;
        while (i < rank) {
            stop[i] = axes[i] ? this.shape[i] : start[i] + 1;
            step[i] = 1;
            ++i;
        }
        return (SliceIterator)this.getSliceIterator(start, stop, step);
    }

    @Override
    public BooleanIterator getBooleanIterator(Dataset choice) {
        return this.getBooleanIterator(choice, true);
    }

    @Override
    public BooleanIterator getBooleanIterator(Dataset choice, boolean value) {
        return BooleanIterator.createIterator(value, this, choice, this);
    }

    @Override
    public Dataset getByBoolean(Dataset selection) {
        this.checkCompatibility(selection);
        int length = ((Number)selection.sum(new boolean[0])).intValue();
        int is = this.getElementsPerItem();
        Object r = DatasetFactory.zeros(is, this.getClass(), length);
        BooleanIterator biter = this.getBooleanIterator(selection);
        int i = 0;
        while (biter.hasNext()) {
            r.setObjectAbs(i, this.getObjectAbs(biter.index));
            i += is;
        }
        return r;
    }

    @Override
    public Dataset getBy1DIndex(IntegerDataset index) {
        int is = this.getElementsPerItem();
        Object r = DatasetFactory.zeros(is, this.getClass(), index.getShapeRef());
        IntegerIterator iter = new IntegerIterator(index, this.size, is);
        int i = 0;
        while (iter.hasNext()) {
            r.setObjectAbs(i, this.getObjectAbs(iter.index));
            i += is;
        }
        return r;
    }

    @Override
    public Dataset getByIndexes(Object ... indexes) {
        IntegersIterator iter = new IntegersIterator(this.shape, indexes);
        int is = this.getElementsPerItem();
        Object r = DatasetFactory.zeros(is, this.getClass(), iter.getShape());
        int[] pos = iter.getPos();
        int i = 0;
        while (iter.hasNext()) {
            r.setObjectAbs(i, this.getObject(pos));
            i += is;
        }
        return r;
    }

    @Override
    public boolean hasFloatingPointElements() {
        Class<?> cls = this.getElementClass();
        return cls == Float.class || cls == Double.class;
    }

    @Override
    public int getElementsPerItem() {
        return InterfaceUtils.getElementsPerItem(this.getClass());
    }

    @Override
    public int getItemBytes() {
        return InterfaceUtils.getItemBytes(this.getElementsPerItem(), this.getClass());
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int[] getShape() {
        if (this.shape == null) {
            logger.warn("Shape is null!!!");
            return new int[0];
        }
        return (int[])this.shape.clone();
    }

    @Override
    public int getRank() {
        return this.shape == null ? 0 : this.shape.length;
    }

    @Override
    public int getNbytes() {
        return this.getSize() * this.getItemBytes();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkShape(int[] shape, int size) {
        if (shape == null) {
            if (size == 0) {
                return;
            }
            logger.error("New shape must not be null for nonzero-sized dataset");
            throw new IllegalArgumentException("New shape must not be null for nonzero-sized dataset");
        }
        int rank = shape.length;
        int found = -1;
        int nsize = 1;
        int i = 0;
        while (i < rank) {
            int d = shape[i];
            if (d == -1) {
                if (found != -1) {
                    logger.error("Can only have one -1 placeholder in shape");
                    throw new IllegalArgumentException("Can only have one -1 placeholder in shape");
                }
                found = i;
            } else {
                nsize *= d;
            }
            ++i;
        }
        if (found >= 0) {
            shape[found] = size / nsize;
            return;
        }
        if (nsize == size) return;
        if (rank == 0) {
            if (size == 0) return;
        }
        logger.error("New shape is not same size as old shape");
        throw new IllegalArgumentException("New size is not same as the old size. Old size is " + size + " new size is " + nsize + " and shape is " + Arrays.toString(shape));
    }

    @Override
    public void setShape(int ... shape) {
        int[] nshape = shape == null ? null : (int[])shape.clone();
        this.checkShape(nshape, this.size);
        if (Arrays.equals(this.shape, nshape)) {
            return;
        }
        if (this.stride != null) {
            int[] oshape = this.shape;
            int orank = oshape.length;
            int nrank = nshape.length;
            int diff = nrank - orank;
            int[] nstride = new int[nrank];
            boolean ones = true;
            int i = 0;
            int j = 0;
            while (i < orank || j < nrank) {
                if (j >= diff && i < orank && j < nrank && oshape[i] == nshape[j]) {
                    nstride[j++] = this.stride[i++];
                    continue;
                }
                if (j < nrank && nshape[j] == 1) {
                    nstride[j++] = 0;
                    continue;
                }
                if (i < orank && oshape[i] == 1) {
                    ++i;
                    continue;
                }
                if (j < nrank) {
                    ++j;
                }
                if (i < orank) {
                    ++i;
                }
                ones = false;
            }
            if (!ones) {
                int[] ostride = this.stride;
                int ob = 0;
                int oe = 1;
                int nb = 0;
                int ne = 1;
                while (ob < orank && nb < nrank) {
                    int nl = nshape[nb];
                    int ol = oshape[ob];
                    if (nl < ol) {
                        while (ne != nrank && (nl *= nshape[ne++]) < ol) {
                        }
                        if (nl != ol) {
                            logger.error("Subshape is incompatible with single dimension");
                            throw new IllegalArgumentException("Subshape is incompatible with single dimension");
                        }
                        int on = ne - 1;
                        while (nshape[on] == 1) {
                            --on;
                        }
                        nstride[on] = ostride[ob];
                        int n = on - 1;
                        while (n >= nb) {
                            if (nshape[n] != 1) {
                                nstride[n] = nshape[on] * nstride[on];
                                on = n;
                            }
                            --n;
                        }
                    } else if (ol < nl) {
                        while (oe != orank && (ol *= oshape[oe++]) < nl) {
                        }
                        if (nl != ol) {
                            logger.error("Single dimension is incompatible with subshape");
                            throw new IllegalArgumentException("Single dimension is incompatible with subshape");
                        }
                        int oo = oe - 1;
                        while (oshape[oo] == 1) {
                            --oo;
                        }
                        int os = ostride[oo];
                        int o = oo - 1;
                        while (o >= ob) {
                            if (oshape[o] != 1) {
                                if (ostride[o] != oshape[oo] * ostride[oo]) {
                                    logger.error("Subshape cannot be a non-contiguous view");
                                    throw new IllegalArgumentException("Subshape cannot be a non-contiguous view");
                                }
                                oo = o;
                            }
                            --o;
                        }
                        nstride[nb] = os;
                    } else {
                        nstride[nb] = ostride[ob];
                    }
                    ob = oe++;
                    nb = ne++;
                }
            }
            this.stride = nstride;
        }
        this.setDirty();
        if (this.shape != null && this.metadata != null) {
            this.reshapeMetadata(this.shape, nshape);
        }
        this.shape = nshape;
    }

    @Override
    public int[] getShapeRef() {
        return this.shape;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int[] getStrides() {
        return this.stride;
    }

    @Override
    public Serializable getBuffer() {
        return this.odata;
    }

    @Override
    public void overrideInternal(Serializable buffer, int ... shape) {
        if (buffer != null) {
            this.odata = buffer;
            this.setData();
            this.setDirty();
        }
        if (shape != null) {
            this.shape = (int[])shape.clone();
            this.size = ShapeUtils.calcSize(this.shape);
        }
    }

    public static int[] createStrides(Dataset a, int[] offset) {
        return AbstractDataset.createStrides(a.getElementsPerItem(), a.getShapeRef(), a.getStrides(), a.getOffset(), offset);
    }

    public static int[] createStrides(int isize, int[] shape, int[] oStride, int oOffset, int[] offset) {
        int[] stride;
        int rank = shape.length;
        if (oStride == null) {
            offset[0] = 0;
            stride = new int[rank];
            int s = isize;
            int j = rank - 1;
            while (j >= 0) {
                stride[j] = s;
                s *= shape[j];
                --j;
            }
        } else {
            offset[0] = oOffset;
            stride = (int[])oStride.clone();
        }
        return stride;
    }

    public static int[] createStrides(SliceND slice, Dataset a, int[] stride, int[] offset) {
        return AbstractDataset.createStrides(slice, a.getElementsPerItem(), a.getShapeRef(), a.getStrides(), a.getOffset(), stride, offset);
    }

    public static int[] createStrides(SliceND slice, int isize, int[] shape, int[] oStride, int oOffset, int[] stride, int[] offset) {
        int[] lstart = slice.getStart();
        int[] lstep = slice.getStep();
        int[] newShape = slice.getShape();
        int rank = shape.length;
        if (oStride == null) {
            int s = isize;
            offset[0] = 0;
            int j = rank - 1;
            while (j >= 0) {
                stride[j] = s * lstep[j];
                offset[0] = offset[0] + s * lstart[j];
                s *= shape[j];
                --j;
            }
        } else {
            offset[0] = oOffset;
            int j = 0;
            while (j < rank) {
                int s = oStride[j];
                stride[j] = lstep[j] * s;
                offset[0] = offset[0] + lstart[j] * s;
                ++j;
            }
        }
        return newShape;
    }

    @Override
    public Dataset getBroadcastView(int ... broadcastShape) {
        AbstractDataset view = this.getView(true);
        if (!Arrays.equals(this.shape, broadcastShape)) {
            List<int[]> nShapes = BroadcastUtils.broadcastShapesToMax(broadcastShape, new int[][]{this.shape});
            view.setShape(nShapes.get(0));
            view.stride = BroadcastUtils.createBroadcastStrides(view, broadcastShape);
            view.base = this;
            view.shape = (int[])broadcastShape.clone();
            view.size = ShapeUtils.calcSize(broadcastShape);
            view.name = view.name == null || view.name.isEmpty() ? "Broadcast from " + Arrays.toString(this.shape) : "Broadcast of " + view.name + " from " + Arrays.toString(this.shape);
        }
        return view;
    }

    @Override
    public Dataset getSliceView(int[] start, int[] stop, int[] step) {
        return this.internalGetSliceView(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSliceView(Slice ... slice) {
        if (slice == null || slice.length == 0) {
            return this.getView(true);
        }
        return this.internalGetSliceView(new SliceND(this.shape, slice));
    }

    @Override
    public Dataset getSliceView(SliceND slice) {
        if (slice != null) {
            this.checkSliceND(slice);
        }
        return this.internalGetSliceView(slice);
    }

    private Dataset internalGetSliceView(SliceND slice) {
        if (slice.isAll()) {
            return this.getView(true);
        }
        int rank = this.shape.length;
        int[] sStride = new int[rank];
        int[] sOffset = new int[1];
        int[] sShape = AbstractDataset.createStrides(slice, this, sStride, sOffset);
        AbstractDataset s = this.getView(false);
        s.shape = sShape;
        s.size = ShapeUtils.calcSize(sShape);
        s.stride = sStride;
        s.offset = sOffset[0];
        s.base = this;
        s.metadata = this.copyMetadata();
        s.sliceMetadata(true, slice);
        s.setDirty();
        s.setName(String.valueOf(this.name) + '[' + slice + ']');
        return s;
    }

    private int getFlat1DIndex(int[] pos) {
        int imax = pos.length;
        if (imax == 0) {
            return 0;
        }
        return this.get1DIndexFromShape(pos);
    }

    protected int getFirst1DIndex() {
        if (this.shape == null) {
            throw new IllegalArgumentException("Cannot find an index from a null shape");
        }
        return this.stride == null ? 0 : this.offset;
    }

    @Override
    public int get1DIndex(int ... n) {
        if (n.length == 0 && this.shape.length == 0) {
            return this.offset;
        }
        return this.stride == null ? this.get1DIndexFromShape(n) : this.get1DIndexFromStrides(n);
    }

    private static void throwAIOOBException(int i, int s, int d) {
        throw new ArrayIndexOutOfBoundsException("Index (" + i + ") out of range [-" + s + SEPARATOR + s + "] in dimension " + d);
    }

    protected int get1DIndex(int i) {
        if (this.shape == null) {
            throw new IllegalArgumentException("Cannot find an index from a null shape");
        }
        if (this.shape.length > 1) {
            logger.error("This dataset is not 1D but was addressed as such");
            throw new UnsupportedOperationException("This dataset is not 1D but was addressed as such");
        }
        if (i < 0) {
            i += this.shape[0];
        }
        if (i < 0 || i >= this.shape[0]) {
            AbstractDataset.throwAIOOBException(i, this.shape[0], 0);
        }
        return this.stride == null ? i : i * this.stride[0] + this.offset;
    }

    protected int get1DIndex(int i, int j) {
        if (this.shape == null) {
            throw new IllegalArgumentException("Cannot find an index from a null shape");
        }
        if (this.shape.length != 2) {
            logger.error("This dataset is not 2D but was addressed as such");
            throw new UnsupportedOperationException("This dataset is not 2D but was addressed as such");
        }
        if (i < 0) {
            i += this.shape[0];
        }
        if (i < 0 || i >= this.shape[0]) {
            AbstractDataset.throwAIOOBException(i, this.shape[0], 0);
        }
        if (j < 0) {
            j += this.shape[1];
        }
        if (j < 0 || j >= this.shape[1]) {
            AbstractDataset.throwAIOOBException(i, this.shape[1], 1);
        }
        return this.stride == null ? i * this.shape[1] + j : i * this.stride[0] + j * this.stride[1] + this.offset;
    }

    protected int get1DIndexFromShape(int[] n) {
        return AbstractDataset.get1DIndexFromShape(this.shape, n);
    }

    protected static int get1DIndexFromShape(int[] shape, int[] n) {
        if (shape == null) {
            throw new IllegalArgumentException("Cannot find an index from a null shape");
        }
        int rank = shape.length;
        if (rank != n.length) {
            String errMsg = String.format("Number of position values must be equal to rank of %d", rank);
            logger.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        int index = 0;
        int i = 0;
        while (i < rank) {
            int si = shape[i];
            int ni = n[i];
            if (ni < 0) {
                ni += si;
            }
            if (ni < 0 || ni >= si) {
                AbstractDataset.throwAIOOBException(ni, si, i);
            }
            index = index * si + ni;
            ++i;
        }
        return index;
    }

    private int get1DIndexFromStrides(int[] n) {
        return AbstractDataset.get1DIndexFromStrides(this.shape, this.stride, this.offset, n);
    }

    private static int get1DIndexFromStrides(int[] shape, int[] stride, int offset, int[] n) {
        if (shape == null) {
            throw new IllegalArgumentException("Cannot find an index from a null shape");
        }
        int rank = shape.length;
        if (rank != n.length) {
            String errMsg = String.format("Number of position values must be equal to rank of %d", rank);
            logger.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        int index = offset;
        int i = 0;
        while (i < rank) {
            int st = stride[i];
            if (st != 0) {
                int si = shape[i];
                int ni = n[i];
                if (ni < 0) {
                    ni += si;
                }
                if (ni < 0 || ni >= si) {
                    AbstractDataset.throwAIOOBException(ni, si, i);
                }
                index += st * ni;
            }
            ++i;
        }
        return index;
    }

    @Override
    public int[] getNDPosition(int n) {
        if (this.isIndexInRange(n)) {
            throw new IllegalArgumentException("Index provided " + n + "is larger then the size of the containing array");
        }
        return this.stride == null ? ShapeUtils.getNDPositionFromShape(n, this.shape) : this.getNDPositionFromStrides(n);
    }

    private boolean isIndexInRange(int n) {
        if (this.stride == null) {
            return n >= this.size;
        }
        return n >= this.getBufferLength();
    }

    protected abstract int getBufferLength();

    private int[] getNDPositionFromStrides(int n) {
        n -= this.offset;
        int rank = this.shape.length;
        if (rank == 1) {
            return new int[]{n / this.stride[0]};
        }
        int[] output = new int[rank];
        int i = 0;
        while (i != n) {
            int j = rank - 1;
            while (j >= 0) {
                int n2 = j;
                output[n2] = output[n2] + 1;
                i += this.stride[j];
                if (output[j] < this.shape[j]) break;
                output[j] = 0;
                i -= this.shape[j] * this.stride[j];
                --j;
            }
            if (j != -1) continue;
            logger.error("Index was not found in this strided dataset");
            throw new IllegalArgumentException("Index was not found in this strided dataset");
        }
        return output;
    }

    @Override
    public int checkAxis(int axis) {
        return ShapeUtils.checkAxis(this.shape.length, axis);
    }

    @Deprecated
    protected static int checkAxis(int rank, int axis) {
        return ShapeUtils.checkAxis(rank, axis);
    }

    public String toString() {
        int rank = this.shape == null ? 0 : this.shape.length;
        StringBuilder out = new StringBuilder();
        if (InterfaceUtils.isElemental(this.getClass())) {
            out.append("Dataset ");
        } else {
            out.append("Compound dataset (");
            out.append(this.getElementsPerItem());
            out.append(") ");
        }
        if (this.name != null && this.name.length() > 0) {
            out.append("'");
            out.append(this.name);
            out.append("' has shape ");
        } else {
            out.append("shape is ");
        }
        out.append('[');
        if (rank > 0) {
            out.append(this.shape[0]);
        }
        int i = 1;
        while (i < rank) {
            out.append(", " + this.shape[i]);
            ++i;
        }
        out.append(']');
        return out.toString();
    }

    @Override
    public String toString(boolean showData) {
        if (!showData) {
            return this.toString();
        }
        if (this.size == 0) {
            return "[]";
        }
        int rank = this.shape == null ? 0 : this.shape.length;
        StringBuilder out = new StringBuilder();
        if (rank > 0) {
            int[] pos = new int[rank];
            StringBuilder lead = new StringBuilder();
            this.printBlocks(out, lead, 0, pos);
        } else {
            out.append(this.getString());
        }
        return out.toString();
    }

    public static void setMaxLineLength(int maxLineLength) {
        maxStringLength = maxLineLength;
    }

    public static int getMaxLineLength() {
        return maxStringLength;
    }

    private StringBuilder makeLine(int end, int[] start) {
        StringBuilder line = new StringBuilder();
        int[] pos = end >= start.length ? Arrays.copyOf(start, end + 1) : start;
        pos[end] = 0;
        line.append('[');
        line.append(this.getString(pos));
        int length = this.shape[end];
        int excess = length - maxStringLength / 3;
        int midIndex = -1;
        if (excess > 0) {
            int index = (length - excess) / 2;
            int y = 1;
            while (y < index) {
                line.append(", ");
                pos[end] = y++;
                line.append(this.getString(pos));
            }
            midIndex = line.length() + 2;
            y = index = (length + excess) / 2;
            while (y < length) {
                line.append(", ");
                pos[end] = y++;
                line.append(this.getString(pos));
            }
        } else {
            int y = 1;
            while (y < length) {
                line.append(", ");
                pos[end] = y++;
                line.append(this.getString(pos));
            }
        }
        line.append(']');
        int lineLength = line.length();
        excess = lineLength - maxStringLength - ELLIPSIS.length() - 1;
        if (excess > 0) {
            int index = (lineLength - excess) / 2;
            index = midIndex > 0 && index > midIndex ? midIndex : line.lastIndexOf(SEPARATOR, index) + 2;
            StringBuilder out = new StringBuilder(line.subSequence(0, index));
            out.append("...,");
            index = (lineLength + excess) / 2;
            index = midIndex > 0 && index <= midIndex ? midIndex - 1 : line.indexOf(SEPARATOR, index) + 1;
            out.append(line.subSequence(index, lineLength));
            return out;
        }
        if (midIndex > 0) {
            StringBuilder out = new StringBuilder(line.subSequence(0, midIndex));
            out.append("..., ");
            out.append(line.subSequence(midIndex, lineLength));
            return out;
        }
        return line;
    }

    private void printBlocks(StringBuilder out, StringBuilder lead, int level, int[] pos) {
        int end;
        char last;
        if (out.length() > 0 && (last = out.charAt(out.length() - 1)) != '[') {
            out.append((CharSequence)lead);
        }
        if (level != (end = this.getRank() - 1)) {
            out.append('[');
            int length = this.shape[level];
            pos[level] = 0;
            StringBuilder newlead = new StringBuilder(lead);
            newlead.append(SPACE);
            this.printBlocks(out, newlead, level + 1, pos);
            if (length < 2) {
                out.append(']');
                return;
            }
            out.append(",\n");
            int i = level + 1;
            while (i < end) {
                out.append(NEWLINE);
                ++i;
            }
            if (length < 6) {
                int x = 1;
                while (x < length - 1) {
                    pos[level] = x;
                    this.printBlocks(out, newlead, level + 1, pos);
                    if (end <= level + 1) {
                        out.append(",\n");
                    } else {
                        out.append(",\n\n");
                    }
                    ++x;
                }
            } else {
                int excess = length - 6;
                int xmax = (length - excess) / 2;
                int x = 1;
                while (x < xmax) {
                    pos[level] = x;
                    this.printBlocks(out, newlead, level + 1, pos);
                    if (end <= level + 1) {
                        out.append(",\n");
                    } else {
                        out.append(",\n\n");
                    }
                    ++x;
                }
                out.append((CharSequence)newlead);
                out.append("...,\n");
                x = xmax = (length + excess) / 2;
                while (x < length - 1) {
                    pos[level] = x;
                    this.printBlocks(out, newlead, level + 1, pos);
                    if (end <= level + 1) {
                        out.append(",\n");
                    } else {
                        out.append(",\n\n");
                    }
                    ++x;
                }
            }
            pos[level] = length - 1;
            this.printBlocks(out, newlead, level + 1, pos);
            out.append(']');
        } else {
            out.append((CharSequence)this.makeLine(end, pos));
        }
    }

    @Override
    public Dataset squeezeEnds() {
        return this.squeeze(true);
    }

    @Override
    public Dataset squeeze() {
        return this.squeeze(false);
    }

    @Override
    public Dataset squeeze(boolean onlyFromEnds) {
        int[] tshape = ShapeUtils.squeezeShape(this.shape, onlyFromEnds);
        int[] oshape = this.shape;
        if (this.stride == null) {
            this.shape = tshape;
        } else {
            int trank = tshape.length;
            int rank = this.shape.length;
            if (trank < rank) {
                int[] tstride = new int[tshape.length];
                if (onlyFromEnds) {
                    int i = 0;
                    while (i < rank) {
                        if (this.shape[i] != 1) {
                            int k = 0;
                            while (k < trank) {
                                tstride[k] = this.stride[i++];
                                ++k;
                            }
                            break;
                        }
                        ++i;
                    }
                } else {
                    int t = 0;
                    int i = 0;
                    while (i < rank) {
                        if (this.shape[i] != 1) {
                            tstride[t++] = this.stride[i];
                        }
                        ++i;
                    }
                }
                this.shape = tshape;
                this.stride = tstride;
            }
        }
        this.setDirty();
        this.reshapeMetadata(oshape, this.shape);
        return this;
    }

    @Override
    public boolean isCompatibleWith(ILazyDataset g) {
        return ShapeUtils.areShapesCompatible(this.shape, g.getShape());
    }

    @Override
    public void checkCompatibility(ILazyDataset g) throws IllegalArgumentException {
        ShapeUtils.checkCompatibility(this, g);
    }

    @Override
    public Dataset reshape(int ... shape) {
        AbstractDataset a;
        try {
            a = this.getView(true);
            a.setShape(shape);
        }
        catch (IllegalArgumentException e) {
            a = this.clone();
            a.setShape(shape);
        }
        return a;
    }

    protected static int calcSteps(double start, double stop, double step) {
        return Math.max(0, (int)Math.ceil((stop - start) / step));
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public Dataset getRealPart() {
        return this;
    }

    @Override
    public Dataset getRealView() {
        return this.getView(true);
    }

    @Override
    public Dataset getSlice(int[] start, int[] stop, int[] step) {
        return this.internalGetSlice(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSlice(Slice ... slice) {
        return this.internalGetSlice(new SliceND(this.shape, slice));
    }

    @Override
    public Dataset getSlice(IMonitor monitor, Slice ... slice) {
        return this.getSlice(slice);
    }

    @Override
    public Dataset getSlice(IMonitor monitor, SliceND slice) {
        return this.getSlice(slice);
    }

    @Override
    public Dataset getSlice(IMonitor monitor, int[] start, int[] stop, int[] step) {
        return this.getSlice(start, stop, step);
    }

    @Override
    public Dataset getSlice(SliceND slice) {
        if (slice != null) {
            this.checkSliceND(slice);
        }
        return this.internalGetSlice(slice);
    }

    private Dataset internalGetSlice(SliceND slice) {
        SliceIterator it = (SliceIterator)this.internalGetSliceIterator(slice);
        AbstractDataset s = this.getSlice(it);
        s.metadata = this.copyMetadata();
        s.setDirty();
        s.sliceMetadata(true, slice);
        return s;
    }

    public abstract AbstractDataset getSlice(SliceIterator var1);

    @Override
    public Dataset setSlice(Object obj, SliceND slice) {
        if (slice != null) {
            this.checkSliceND(slice);
        }
        return this.internalSetSlice(obj, slice);
    }

    private Dataset internalSetSlice(Object obj, SliceND slice) {
        Dataset ds;
        if (obj instanceof Dataset) {
            ds = (Dataset)obj;
        } else if (obj instanceof IDataset) {
            ds = DatasetUtils.convertToDataset((IDataset)obj);
        } else {
            Class<Object> dClass = this.getClass();
            if (!BooleanDataset.class.equals(dClass)) {
                dClass = InterfaceUtils.getLargestInterface(this);
            }
            ds = DatasetFactory.createFromObject(this.getElementsPerItem(), dClass, obj, new int[0]);
        }
        return this.setSlicedView(this.getSliceView(slice), ds);
    }

    @Override
    public Dataset setSlice(Object obj, int[] start, int[] stop, int[] step) {
        return this.internalSetSlice(obj, new SliceND(this.shape, start, stop, step));
    }

    abstract Dataset setSlicedView(Dataset var1, Dataset var2);

    @Override
    public Dataset setSlice(Object obj, Slice ... slice) {
        if (slice == null || slice.length == 0) {
            return this.internalSetSlice(obj, new SliceND(this.shape));
        }
        return this.internalSetSlice(obj, new SliceND(this.shape, slice));
    }

    @Override
    public boolean all() {
        return Comparisons.allTrue(this);
    }

    @Override
    public BooleanDataset all(int axis) {
        return Comparisons.allTrue(this, axis);
    }

    @Override
    public boolean any() {
        return Comparisons.anyTrue(this);
    }

    @Override
    public BooleanDataset any(int axis) {
        return Comparisons.anyTrue(this, axis);
    }

    @Override
    public Dataset ifloorDivide(Object o) {
        return this.idivide(o).ifloor();
    }

    @Override
    public double residual(Object o) {
        return this.residual(o, null, false);
    }

    @Override
    public double residual(Object o, boolean ignoreNaNs) {
        return this.residual(o, null, ignoreNaNs);
    }

    protected StatisticsMetadata<Number> getStats() {
        StatisticsMetadataImpl<Number> md = this.getFirstMetadata(StatisticsMetadata.class);
        if (md == null || md.isDirty(this)) {
            md = new StatisticsMetadataImpl<Number>();
            md.initialize(this);
            this.setMetadata(md);
        }
        return md;
    }

    protected StatisticsMetadata<String> getStringStats() {
        StatisticsMetadataImpl<String> md = this.getFirstMetadata(StatisticsMetadata.class);
        if (md == null || md.isDirty(this)) {
            md = new StatisticsMetadataImpl<String>();
            md.initialize(this);
            this.setMetadata(md);
        }
        return md;
    }

    @Override
    public Number max(boolean ... ignoreInvalids) {
        return this.getStats().getMaximum(ignoreInvalids);
    }

    @Override
    public Dataset max(int axis, boolean ... ignoreInvalids) {
        return this.getStats().getMaximum(axis, ignoreInvalids);
    }

    @Override
    public Dataset max(int[] axes, boolean ... ignoreInvalids) {
        return this.getStats().getMaximum(axes, ignoreInvalids);
    }

    @Override
    public Number min(boolean ... ignoreInvalids) {
        return this.getStats().getMinimum(ignoreInvalids);
    }

    @Override
    public Dataset min(int axis, boolean ... ignoreInvalids) {
        return this.getStats().getMinimum(axis, ignoreInvalids);
    }

    @Override
    public Dataset min(int[] axes, boolean ... ignoreInvalids) {
        return this.getStats().getMinimum(axes, ignoreInvalids);
    }

    @Override
    public int argMax(boolean ... ignoreInvalids) {
        return this.getFlat1DIndex(this.maxPos(ignoreInvalids));
    }

    @Override
    public IntegerDataset argMax(int axis, boolean ... ignoreInvalids) {
        return (IntegerDataset)this.getStats().getArgMaximum(axis, ignoreInvalids);
    }

    @Override
    public int argMin(boolean ... ignoreInvalids) {
        return this.getFlat1DIndex(this.minPos(ignoreInvalids));
    }

    @Override
    public IntegerDataset argMin(int axis, boolean ... ignoreInvalids) {
        return (IntegerDataset)this.getStats().getArgMinimum(axis, ignoreInvalids);
    }

    @Override
    public Number peakToPeak(boolean ... ignoreInvalids) {
        return InterfaceUtils.fromDoubleToBiggestNumber(this.getClass(), this.max(ignoreInvalids).doubleValue() - this.min(ignoreInvalids).doubleValue());
    }

    @Override
    public Dataset peakToPeak(int axis, boolean ... ignoreInvalids) {
        return Maths.subtract(this.max(axis, ignoreInvalids), this.min(axis, ignoreInvalids));
    }

    @Override
    public Dataset peakToPeak(int[] axes, boolean ... ignoreInvalids) {
        return Maths.subtract(this.max(axes, ignoreInvalids), this.min(axes, ignoreInvalids));
    }

    @Override
    public long count(boolean ... ignoreInvalids) {
        return this.getStats().getCount(ignoreInvalids);
    }

    @Override
    public Dataset count(int axis, boolean ... ignoreInvalids) {
        return this.getStats().getCount(axis, ignoreInvalids);
    }

    @Override
    public Dataset count(int[] axes, boolean ... ignoreInvalids) {
        return this.getStats().getCount(axes, ignoreInvalids);
    }

    @Override
    public Object sum(boolean ... ignoreInvalids) {
        return InterfaceUtils.toBiggestNumber(this.getClass(), this.getStats().getSum(ignoreInvalids));
    }

    @Override
    public Dataset sum(int axis, boolean ... ignoreInvalids) {
        return this.getStats().getSum(axis, ignoreInvalids);
    }

    @Override
    public Dataset sum(int[] axes, boolean ... ignoreInvalids) {
        return this.getStats().getSum(axes, ignoreInvalids);
    }

    @Override
    public Object product(boolean ... ignoreInvalids) {
        return Stats.product((Dataset)this, ignoreInvalids);
    }

    @Override
    public Dataset product(int axis, boolean ... ignoreInvalids) {
        return Stats.product((Dataset)this, axis, ignoreInvalids);
    }

    @Override
    public Dataset product(int[] axes, boolean ... ignoreInvalids) {
        return Stats.product((Dataset)this, axes, ignoreInvalids);
    }

    @Override
    public Object mean(boolean ... ignoreInvalids) {
        return this.getStats().getMean(ignoreInvalids);
    }

    @Override
    public Dataset mean(int axis, boolean ... ignoreInvalids) {
        return this.getStats().getMean(axis, ignoreInvalids);
    }

    @Override
    public Dataset mean(int[] axes, boolean ... ignoreInvalids) {
        return this.getStats().getMean(axes, ignoreInvalids);
    }

    @Override
    public double variance() {
        return this.variance(false, new boolean[0]);
    }

    @Override
    public double variance(boolean isWholePopulation, boolean ... ignoreInvalids) {
        return this.getStats().getVariance(isWholePopulation, ignoreInvalids);
    }

    @Override
    public Dataset variance(int axis) {
        return this.getStats().getVariance(axis, false, new boolean[0]);
    }

    @Override
    public Dataset variance(int[] axes) {
        return this.getStats().getVariance(axes, false, new boolean[0]);
    }

    @Override
    public Dataset variance(int axis, boolean isWholePopulation, boolean ... ignoreInvalids) {
        return this.getStats().getVariance(axis, isWholePopulation, ignoreInvalids);
    }

    @Override
    public Dataset variance(int[] axes, boolean isWholePopulation, boolean ... ignoreInvalids) {
        return this.getStats().getVariance(axes, isWholePopulation, ignoreInvalids);
    }

    @Override
    public double stdDeviation() {
        return Math.sqrt(this.variance());
    }

    @Override
    public double stdDeviation(boolean isWholePopulation, boolean ... ignoreInvalids) {
        return Math.sqrt(this.variance(isWholePopulation, ignoreInvalids));
    }

    @Override
    public Dataset stdDeviation(int axis) {
        return Maths.sqrt(this.variance(axis, false, new boolean[0]));
    }

    @Override
    public Dataset stdDeviation(int[] axes) {
        return Maths.sqrt(this.variance(axes, false, new boolean[0]));
    }

    @Override
    public Dataset stdDeviation(int axis, boolean isWholePopulation, boolean ... ignoreInvalids) {
        return Maths.sqrt(this.variance(axis, isWholePopulation, ignoreInvalids));
    }

    @Override
    public Dataset stdDeviation(int[] axes, boolean isWholePopulation, boolean ... ignoreInvalids) {
        return Maths.sqrt(this.variance(axes, isWholePopulation, ignoreInvalids));
    }

    @Override
    public double rootMeanSquare(boolean ... ignoreInvalids) {
        StatisticsMetadata<Number> stats = this.getStats();
        double mean = stats.getMean(ignoreInvalids).doubleValue();
        double var = stats.getVariance(true, ignoreInvalids);
        return Math.sqrt(var + mean * mean);
    }

    @Override
    public Dataset rootMeanSquare(int axis, boolean ... ignoreInvalids) {
        StatisticsMetadata<Number> stats = this.getStats();
        Dataset v = stats.getVariance(axis, true, ignoreInvalids);
        Dataset m = stats.getMean(axis, ignoreInvalids);
        Dataset result = Maths.multiply(m, m);
        return Maths.sqrt(result.iadd(v));
    }

    @Override
    public Dataset rootMeanSquare(int[] axes, boolean ... ignoreInvalids) {
        StatisticsMetadata<Number> stats = this.getStats();
        Dataset v = stats.getVariance(axes, true, ignoreInvalids);
        Dataset m = stats.getMean(axes, ignoreInvalids);
        Dataset result = Maths.multiply(m, m);
        return Maths.sqrt(result.iadd(v));
    }

    protected abstract void setItemDirect(int var1, int var2, Object var3);

    private Dataset getBroadcastedInternalError() {
        if (this.shape == null) {
            throw new IllegalArgumentException("Cannot get error for null dataset");
        }
        ILazyDataset led = super.getErrors();
        if (led == null) {
            return null;
        }
        Dataset ed = null;
        try {
            ed = DatasetUtils.sliceAndConvertLazyDataset(led);
        }
        catch (DatasetException e) {
            logger.error("Could not get data from lazy dataset", (Throwable)e);
        }
        if (led != ed) {
            this.setErrors(ed);
        }
        return ed.getBroadcastView(this.shape);
    }

    @Override
    public Dataset getErrors() {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return ed;
    }

    @Override
    public double getError() {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return 0.0;
        }
        return ed.getDouble();
    }

    @Override
    public double getError(int i) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return 0.0;
        }
        return ed.getDouble(i);
    }

    @Override
    public double getError(int i, int j) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return 0.0;
        }
        return ed.getDouble(i, j);
    }

    @Override
    public double getError(int ... pos) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return 0.0;
        }
        return ed.getDouble(pos);
    }

    @Override
    public double[] getErrorArray(int i) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return new double[]{this.getError(i)};
    }

    @Override
    public double[] getErrorArray(int i, int j) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return new double[]{this.getError(i, j)};
    }

    @Override
    public double[] getErrorArray(int ... pos) {
        Dataset ed = this.getBroadcastedInternalError();
        if (ed == null) {
            return null;
        }
        return new double[]{this.getError(pos)};
    }

    protected Dataset getInternalSquaredError() {
        Dataset sed = this.getErrorBuffer().getBroadcastView(this.shape);
        return sed;
    }

    @Override
    public Dataset getErrorBuffer() {
        ErrorMetadata emd = this.getErrorMetadata();
        if (emd == null) {
            return null;
        }
        if (!(emd instanceof ErrorMetadataImpl)) {
            ILazyDataset led = emd.getError();
            try {
                Dataset ed = DatasetUtils.sliceAndConvertLazyDataset(led);
                emd = MetadataFactory.createMetadata(ErrorMetadata.class, new Object[0]);
                this.setMetadata(emd);
                emd.setError(ed);
            }
            catch (MetadataException me) {
                logger.error("Could not create metadata", (Throwable)me);
            }
            catch (DatasetException e) {
                logger.error("Could not get data from lazy dataset", (Throwable)e);
            }
        }
        return ((ErrorMetadataImpl)emd).getSquaredError();
    }

    @Override
    public void setErrorBuffer(Serializable buffer) {
        if (this.shape == null) {
            throw new IllegalArgumentException("Cannot set error buffer for null dataset");
        }
        if (buffer == null) {
            this.clearMetadata(ErrorMetadata.class);
            return;
        }
        IDataset d = (IDataset)this.createFromSerializable(buffer, false);
        ErrorMetadata emd = this.getErrorMetadata();
        if (!(emd instanceof ErrorMetadataImpl)) {
            try {
                emd = MetadataFactory.createMetadata(ErrorMetadata.class, new Object[0]);
                this.setMetadata(emd);
            }
            catch (MetadataException me) {
                logger.error("Could not create metadata", (Throwable)me);
            }
        }
        ((ErrorMetadataImpl)emd).setSquaredError(d);
    }
}

