/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;

public class AggregateDataset
extends LazyDatasetBase
implements ILazyDataset {
    private static final long serialVersionUID = -5523566223386837581L;
    private ILazyDataset[] data = null;
    private int[] map = null;
    private int[] offset = null;
    private int size;
    private int dtype = -1;
    private int isize;
    protected AggregateDataset base = null;
    private int[] sliceStart = null;
    private int[] sliceStep = null;

    public static int[][] calcShapes(boolean extend, ILazyDataset ... datasets) {
        if (datasets.length == 0) {
            throw new IllegalArgumentException("No datasets given");
        }
        int maxRank = -1;
        ILazyDataset[] iLazyDatasetArray = datasets;
        int n = datasets.length;
        int n2 = 0;
        while (n2 < n) {
            ILazyDataset d = iLazyDatasetArray[n2];
            if (d == null) {
                throw new IllegalArgumentException("Null dataset given");
            }
            int r = d.getRank();
            if (r > maxRank) {
                maxRank = r;
            }
            ++n2;
        }
        if (extend) {
            ++maxRank;
        }
        int[][] shapes = new int[datasets.length][];
        int j = 0;
        while (j < datasets.length) {
            ILazyDataset d = datasets[j];
            int[] s = d.getShape();
            if (s.length < maxRank) {
                int[] ns = new int[maxRank];
                int start = maxRank - s.length;
                int i = 0;
                while (i < start) {
                    ns[i] = 1;
                    ++i;
                }
                i = 0;
                while (i < s.length) {
                    ns[i + start] = s[i];
                    ++i;
                }
                s = ns;
            }
            shapes[j] = s;
            ++j;
        }
        return shapes;
    }

    AggregateDataset(int itemSize, int[] shape, int dtype) {
        this.isize = itemSize;
        this.shape = (int[])shape.clone();
        try {
            this.size = ShapeUtils.calcSize(shape);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.size = Integer.MAX_VALUE;
        }
        this.dtype = dtype;
    }

    public AggregateDataset(boolean extend, ILazyDataset ... datasets) {
        int[][] shapes = AggregateDataset.calcShapes(extend, datasets);
        int[] s = shapes[0];
        int axis = extend ? -1 : 0;
        int j = 1;
        while (j < shapes.length) {
            if (!ShapeUtils.areShapesCompatible(s, shapes[j], axis)) {
                throw new IllegalArgumentException("Dataset '" + datasets[j].getName() + "' has wrong shape");
            }
            ++j;
        }
        int maxRank = s.length;
        this.data = new ILazyDataset[datasets.length];
        this.isize = datasets[0].getElementsPerItem();
        int j2 = 0;
        while (j2 < datasets.length) {
            ILazyDataset d = datasets[j2];
            int[] ds = d.getShape();
            if (ds.length < maxRank) {
                d = d.clone();
                d.setShape(shapes[j2]);
            }
            this.data[j2] = d;
            if (d.getElementsPerItem() != this.isize) {
                throw new IllegalArgumentException("All datasets must have the same number of elements");
            }
            ++j2;
        }
        this.shape = new int[maxRank];
        int i = 1;
        while (i < this.shape.length) {
            this.shape[i] = s[i];
            ++i;
        }
        if (extend) {
            this.shape[0] = this.data.length;
        } else {
            j2 = 0;
            while (j2 < datasets.length) {
                this.shape[0] = this.shape[0] + shapes[j2][0];
                ++j2;
            }
        }
        try {
            this.size = ShapeUtils.calcSize(this.shape);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.size = Integer.MAX_VALUE;
        }
        this.offset = new int[this.data.length];
        int cd = 0;
        int i2 = 0;
        while (i2 < this.data.length) {
            this.offset[i2] = cd;
            cd += this.data[i2].getShape()[0];
            ++i2;
        }
        this.map = new int[this.shape[0]];
        int k = 0;
        int i3 = 0;
        while (i3 < this.data.length) {
            int jmax = this.data[i3].getShape()[0];
            int j3 = 0;
            while (j3 < jmax) {
                this.map[k++] = i3;
                ++j3;
            }
            ++i3;
        }
        ILazyDataset[] iLazyDatasetArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            ILazyDataset d = iLazyDatasetArray[n2];
            this.dtype = d instanceof LazyDatasetBase ? DTypeUtils.getBestDType(this.dtype, ((LazyDatasetBase)d).getDType()) : DTypeUtils.getBestDType(this.dtype, DTypeUtils.getDTypeFromClass(d.getElementClass(), d.getElementsPerItem()));
            ++n2;
        }
        iLazyDatasetArray = this.data;
        n = this.data.length;
        n2 = 0;
        while (n2 < n) {
            ILazyDataset d = iLazyDatasetArray[n2];
            String n3 = d.getName();
            if (n3 != null) {
                this.name = n3;
                break;
            }
            ++n2;
        }
    }

    @Override
    public Class<?> getElementClass() {
        return DTypeUtils.getElementClass(this.dtype);
    }

    @Override
    public int getElementsPerItem() {
        return this.isize;
    }

    @Override
    public int getDType() {
        return this.dtype;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setShape(int ... shape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ILazyDataset squeezeEnds() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Dataset getSlice(int[] start, int[] stop, int[] step) throws DatasetException {
        return this.getSlice(null, new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSlice(IMonitor monitor, int[] start, int[] stop, int[] step) throws DatasetException {
        return this.getSlice(monitor, new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSlice(IMonitor monitor, SliceND slice) throws DatasetException {
        Dataset a;
        int op;
        int[] start = slice.getStart();
        int[] stop = slice.getStop();
        int[] step = slice.getStep();
        if (this.base != null) {
            int i = 0;
            while (i < this.shape.length) {
                start[i] = this.sliceStart[i] + start[i] * this.sliceStep[i];
                stop[i] = this.sliceStart[i] + (stop[i] - 1) * this.sliceStep[i] + 1;
                step[i] = step[i] * this.sliceStep[i];
                ++i;
            }
            return this.base.getSlice(monitor, start, stop, step);
        }
        int fb = start[0];
        int fe = stop[0];
        int fs = step[0];
        ArrayList<Dataset> sliced = new ArrayList<Dataset>();
        int p = op = fb;
        ILazyDataset od = this.data[this.map[op]];
        while (p < fe) {
            if (monitor != null && monitor.isCancelled()) {
                throw new DatasetException("Slice cancelled");
            }
            ILazyDataset nd = this.data[this.map[p]];
            if (nd != od) {
                start[0] = op - this.offset[this.map[op]];
                stop[0] = p - this.offset[this.map[op]];
                a = DatasetUtils.convertToDataset(od.getSlice(monitor, start, stop, step));
                sliced.add(a.cast(this.dtype));
                od = nd;
                op = p;
            }
            p += fs;
        }
        start[0] = op - this.offset[this.map[op]];
        stop[0] = p - this.offset[this.map[op]];
        a = DatasetUtils.convertToDataset(od.getSlice(monitor, start, stop, step));
        sliced.add(a.cast(this.dtype));
        Dataset d = DatasetUtils.concatenate(sliced.toArray(new Dataset[0]), 0);
        d.setName(this.name);
        return d;
    }

    @Override
    public Dataset getSlice(Slice ... slice) throws DatasetException {
        return this.getSlice((IMonitor)null, slice);
    }

    @Override
    public Dataset getSlice(SliceND slice) throws DatasetException {
        return this.getSlice(null, slice);
    }

    @Override
    public Dataset getSlice(IMonitor monitor, Slice ... slice) throws DatasetException {
        return this.getSlice(monitor, new SliceND(this.shape, slice));
    }

    @Override
    public AggregateDataset getSliceView(Slice ... slice) {
        return this.getSliceView(new SliceND(this.shape, slice));
    }

    @Override
    public AggregateDataset getSliceView(int[] start, int[] stop, int[] step) {
        return this.getSliceView(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public AggregateDataset getSliceView(SliceND slice) {
        AggregateDataset lazy = new AggregateDataset(this.isize, slice.getShape(), this.dtype);
        lazy.sliceStart = slice.getStart();
        lazy.sliceStep = slice.getStep();
        lazy.name = String.valueOf(this.name) + "[" + slice + "]";
        lazy.base = this.base == null ? this : this.base;
        return lazy;
    }

    @Override
    public AggregateDataset getTransposedView(int ... axes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public AggregateDataset clone() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        int rank;
        StringBuilder out = new StringBuilder();
        if (this.name != null && this.name.length() > 0) {
            out.append("Aggregate dataset '");
            out.append(this.name);
            out.append("' has shape [");
        } else {
            out.append("Aggregate dataset shape is [");
        }
        int n = rank = this.shape == null ? 0 : this.shape.length;
        if (rank > 0 && this.shape[0] > 0) {
            out.append(this.shape[0]);
        }
        int i = 1;
        while (i < rank) {
            out.append(", " + this.shape[i]);
            ++i;
        }
        out.append(']');
        return out.toString();
    }

    @Override
    public void setError(Serializable errors) {
        throw new RuntimeException("setLazyErrors is unimplemented for " + this.getClass().getSimpleName());
    }

    @Override
    public ILazyDataset getError() {
        return null;
    }
}

