/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.SliceND;

public class SliceIterator
extends IndexIterator {
    int[] shape;
    int isize;
    int endrank;
    int[] gap;
    int imax;
    int[] start;
    int[] stop;
    int[] step;
    int[] sshape;
    int[] pos;
    int istep;

    SliceIterator() {
    }

    public SliceIterator(int[] shape, int length, int[] sshape) {
        this(shape, length, null, null, sshape, 1);
    }

    public SliceIterator(int[] shape, int length, int[] start, int[] sshape) {
        this(shape, length, start, null, sshape, 1);
    }

    public SliceIterator(int[] shape, int length, int[] sshape, int isize) {
        this(shape, length, null, null, sshape, isize);
    }

    public SliceIterator(int[] shape, int length, int[] start, int[] sshape, int isize) {
        this(shape, length, start, null, sshape, isize);
    }

    public SliceIterator(int[] shape, int length, int[] start, int[] step, int[] sshape) {
        this(shape, length, start, step, sshape, 1);
    }

    public SliceIterator(int[] shape, int length, SliceND slice) {
        this(shape, length, slice.getStart(), slice.getStep(), slice.getShape(), 1);
    }

    public SliceIterator(int[] shape, int length, int isize, SliceND slice) {
        this(shape, length, slice.getStart(), slice.getStep(), slice.getShape(), isize);
    }

    public SliceIterator(int[] shape, int length, int[] start, int[] step, int[] sshape, int isize) {
        this.isize = isize;
        int rank = shape.length;
        this.endrank = rank - 1;
        this.shape = shape;
        this.start = new int[rank];
        this.sshape = sshape;
        if (step == null) {
            this.step = new int[rank];
            Arrays.fill(this.step, 1);
        } else {
            this.step = step;
        }
        if (rank == 0) {
            this.istep = isize;
            this.imax = length * isize;
            this.stop = new int[0];
            this.pos = new int[0];
            this.gap = null;
        } else {
            this.istep = this.step[this.endrank] * isize;
            this.imax = length * isize;
            this.stop = new int[rank];
            this.gap = new int[this.endrank + 1];
            this.pos = new int[rank];
            this.calcGap();
        }
        this.setStart(start);
    }

    void calcGap() {
        int chunk = this.isize;
        int i = this.endrank;
        while (i >= 0) {
            this.stop[i] = this.start[i] + this.sshape[i] * this.step[i];
            if (this.step[i] < 0) {
                int n = i;
                this.stop[n] = this.stop[n] + 1;
            }
            if (i > 0) {
                this.gap[i] = (this.shape[i] * this.step[i - 1] - this.sshape[i] * this.step[i]) * chunk;
                chunk *= this.shape[i];
            }
            --i;
        }
    }

    public void setStart(int ... newStart) {
        int rank = this.shape.length;
        if (rank == 0) {
            this.index = -this.istep;
            return;
        }
        if (newStart == null) {
            int i = 0;
            while (i < rank) {
                this.start[i] = 0;
                ++i;
            }
        } else {
            if (newStart.length > rank) {
                throw new IllegalArgumentException("Length of start array greater than rank");
            }
            int extra = rank - newStart.length;
            int i = 0;
            while (i < extra) {
                this.start[i] = 0;
                ++i;
            }
            i = 0;
            while (i < newStart.length) {
                this.start[i + extra] = newStart[i];
                ++i;
            }
        }
        this.reset();
        this.calcGap();
    }

    @Override
    public void reset() {
        if (this.shape.length == 0) {
            this.index = -this.istep;
        } else {
            int i = 0;
            while (i < this.shape.length) {
                this.pos[i] = this.start[i];
                ++i;
            }
            int n = this.endrank;
            this.pos[n] = this.pos[n] - this.step[this.endrank];
            this.index = this.pos[0];
            int j = 1;
            while (j <= this.endrank) {
                this.index = this.index * this.shape[j] + this.pos[j];
                ++j;
            }
            this.index *= this.isize;
        }
    }

    @Override
    public boolean hasNext() {
        int j = this.endrank;
        while (j >= 0) {
            int n = j;
            this.pos[n] = this.pos[n] + this.step[j];
            if (this.pos[j] >= this.stop[j] != this.step[j] > 0) break;
            this.pos[j] = this.start[j];
            this.index += this.gap[j];
            --j;
        }
        if (j == -1 && this.endrank >= 0) {
            this.index = this.imax;
            return false;
        }
        this.index += this.istep;
        return this.index < this.imax;
    }

    public int[] getStart() {
        return this.start;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    public int[] getStep() {
        return this.step;
    }

    @Override
    public int[] getShape() {
        return this.sshape;
    }
}

