/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.january.geometry.Cylinder;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.impl.ShapeImpl;
import org.eclipse.january.geometry.util.MeshUtils;

public class CylinderImpl
extends ShapeImpl
implements Cylinder {
    protected static final double RADIUS_EDEFAULT = 0.0;
    protected double radius = 0.0;
    protected static final double HEIGHT_EDEFAULT = 0.0;
    protected double height = 0.0;
    private final int RESOLUTION = 50;
    private final int SEGMENTS = 2;
    protected double prevHeight = 0.0;
    protected double prevRadius = 0.0;

    protected CylinderImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.CYLINDER;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double newRadius) {
        if (newRadius != this.radius) {
            double oldRadius = this.radius;
            this.radius = newRadius;
            if (this.properties.get("radius") == null || (Double)this.properties.get("radius") != this.radius) {
                this.properties.put("radius", this.radius);
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldRadius, this.radius));
            }
        }
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double newHeight) {
        if (newHeight != this.height) {
            double oldHeight = this.height;
            this.height = newHeight;
            if (this.properties.get("height") == null || (Double)this.properties.get("height") != this.height) {
                this.properties.put("height", this.height);
            }
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldHeight, this.height));
            }
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getRadius();
            }
            case 9: {
                return this.getHeight();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setRadius((Double)newValue);
                return;
            }
            case 9: {
                this.setHeight((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setRadius(0.0);
                return;
            }
            case 9: {
                this.setHeight(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.radius != 0.0;
            }
            case 9: {
                return this.height != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (radius: ");
        result.append(this.radius);
        result.append(", height: ");
        result.append(this.height);
        result.append(')');
        return result.toString();
    }

    @Override
    public EList<Triangle> getTriangles() {
        if (this.prevRadius == this.radius && this.prevHeight == this.height && this.triangles != null && !this.triangles.isEmpty()) {
            if (this.triangles != null) {
                return this.triangles;
            }
            this.triangles = new BasicInternalEList(Triangle.class);
            return this.triangles;
        }
        this.prevRadius = this.radius;
        this.prevHeight = this.height;
        this.triangles = new BasicInternalEList(Triangle.class);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>();
        float[] circle = new float[100];
        circle = MeshUtils.createCircle((float)this.radius, 50);
        int blockSize = 450;
        int i = 0;
        while (i <= 2) {
            int j = 0;
            while (j < 50) {
                Vertex vertex = GeometryFactory.eINSTANCE.createVertex();
                vertex.setX(circle[j * 2]);
                vertex.setZ(circle[j * 2 + 1]);
                vertex.setY(-this.height / 2.0 + (double)i * this.height / 2.0);
                vertices.add(vertex);
                ++j;
            }
            ++i;
        }
        Vertex bottom = GeometryFactory.eINSTANCE.createVertex();
        bottom.setX(0.0);
        bottom.setY(-this.height / 2.0);
        bottom.setZ(0.0);
        vertices.add(bottom);
        Vertex top = GeometryFactory.eINSTANCE.createVertex();
        top.setX(0.0);
        top.setY(this.height / 2.0);
        top.setZ(0.0);
        vertices.add(top);
        int axialSegment = 0;
        while (axialSegment < 2) {
            int radialSegment = 0;
            while (radialSegment < 50) {
                Triangle t0 = GeometryFactory.eINSTANCE.createTriangle();
                t0.getVertices().add((Object)((Vertex)((Vertex)vertices.get((axialSegment + 1) * 50 + (radialSegment + 1) % 50)).clone()));
                t0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(axialSegment * 50 + (radialSegment + 1) % 50)).clone()));
                t0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(axialSegment * 50 + radialSegment)).clone()));
                this.triangles.add((Object)t0);
                Triangle t1 = GeometryFactory.eINSTANCE.createTriangle();
                t1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(axialSegment * 50 + radialSegment)).clone()));
                t1.getVertices().add((Object)((Vertex)((Vertex)vertices.get((axialSegment + 1) * 50 + radialSegment)).clone()));
                t1.getVertices().add((Object)((Vertex)((Vertex)vertices.get((axialSegment + 1) * 50 + (radialSegment + 1) % 50)).clone()));
                this.triangles.add((Object)t1);
                ++radialSegment;
            }
            ++axialSegment;
        }
        int radialSegment = 0;
        while (radialSegment < 50) {
            Triangle t0 = GeometryFactory.eINSTANCE.createTriangle();
            t0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(blockSize / 3)).clone()));
            t0.getVertices().add((Object)((Vertex)((Vertex)vertices.get(radialSegment)).clone()));
            t0.getVertices().add((Object)((Vertex)((Vertex)vertices.get((radialSegment + 1) % 50)).clone()));
            this.triangles.add((Object)t0);
            Triangle t1 = GeometryFactory.eINSTANCE.createTriangle();
            t1.getVertices().add((Object)((Vertex)vertices.get(100 + (radialSegment + 1) % 50)));
            t1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(100 + radialSegment)).clone()));
            t1.getVertices().add((Object)((Vertex)((Vertex)vertices.get(blockSize / 3 + 1)).clone()));
            this.triangles.add((Object)t1);
            ++radialSegment;
        }
        for (Triangle tri : this.triangles) {
            Vertex normal = tri.getNormal();
            EList<Vertex> currVertices = tri.getVertices();
            Vertex v0 = (Vertex)currVertices.get(0);
            Vertex v1 = (Vertex)currVertices.get(1);
            Vertex v2 = (Vertex)currVertices.get(2);
            normal.setX((v0.getX() + v1.getX() + v2.getX()) / 3.0);
            normal.setY((v0.getY() + v1.getY() + v2.getY()) / 3.0);
            normal.setZ((v0.getZ() + v1.getZ() + v2.getZ()) / 3.0);
        }
        return this.triangles;
    }

    @Override
    public void setProperty(String property, double value) {
        if ("height".equals(property)) {
            this.setHeight(value);
        } else if ("radius".equals(property)) {
            this.setRadius(value);
        }
        super.setProperty(property, value);
    }

    @Override
    public Object clone() {
        Cylinder clone = GeometryFactory.eINSTANCE.createCylinder();
        clone.copy(this);
        return clone;
    }
}

