/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import com.google.inject.Injector;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.january.geometry.Geometry;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.INode;
import org.eclipse.january.geometry.STLGeometryImporter;
import org.eclipse.january.geometry.Shape;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.impl.ComplexTriangle;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import xtext.STLStandaloneSetup;

public class STLGeometryImporterImpl
extends MinimalEObjectImpl.Container
implements STLGeometryImporter {
    protected EList<String> fileTypes;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;

    protected STLGeometryImporterImpl() {
    }

    protected EClass eStaticClass() {
        return GeometryPackage.Literals.STL_GEOMETRY_IMPORTER;
    }

    @Override
    public EList<String> getFileTypes() {
        if (this.fileTypes == null) {
            this.fileTypes = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 0);
        }
        return this.fileTypes;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public Geometry load(Path path) {
        INode geometry = null;
        Injector injector = new STLStandaloneSetup().createInjectorAndDoEMFRegistration();
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        Resource resource = resourceSet.getResource(URI.createFileURI((String)path.toFile().getAbsolutePath()), true);
        EList contents = resource.getContents();
        if (contents != null && !contents.isEmpty()) {
            Geometry g = (Geometry)contents.get(0);
            geometry = g.getNodes().isEmpty() || ((Shape)g.getNodes().get(0)).getTriangles().isEmpty() ? this.loadBinary(path) : g;
        }
        for (final INode node : geometry.getNodes()) {
            EList<Triangle> triangles = node.getTriangles();
            ArrayList<ComplexTriangle> newTriangles = new ArrayList<ComplexTriangle>();
            ArrayList<Vertex> vertices = new ArrayList<Vertex>();
            for (Triangle tri : triangles) {
                ArrayList<Vertex> currVertices = new ArrayList<Vertex>();
                for (Vertex v : tri.getVertices()) {
                    if (!vertices.contains(v)) {
                        Vertex clone = (Vertex)v.clone();
                        vertices.add(clone);
                        currVertices.add(clone);
                        continue;
                    }
                    currVertices.add((Vertex)vertices.get(vertices.indexOf(v)));
                }
                ComplexTriangle cTri = new ComplexTriangle((Vertex)currVertices.get(0), (Vertex)currVertices.get(1), (Vertex)currVertices.get(2));
                cTri.getNormal().setX(tri.getNormal().getX());
                cTri.getNormal().setY(tri.getNormal().getY());
                cTri.getNormal().setZ(tri.getNormal().getZ());
                cTri.eAdapters().add((Object)new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        node.eNotify(notification);
                    }
                });
                newTriangles.add(cTri);
            }
            node.getTriangles().clear();
            for (Triangle tri : newTriangles) {
                node.getTriangles().add((Object)tri);
            }
        }
        return geometry;
    }

    private Geometry loadBinary(Path path) {
        Geometry geometry = GeometryFactory.eINSTANCE.createGeometry();
        geometry.setName(path.getFileName().toString());
        Shape shape = GeometryFactory.eINSTANCE.createShape();
        geometry.getNodes().add((Object)shape);
        try {
            byte[] fileBytes = Files.readAllBytes(path);
            ByteBuffer buffer = ByteBuffer.wrap(fileBytes, 80, fileBytes.length - 80);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int triNum = buffer.getInt();
            int i = 0;
            while (i < triNum) {
                Triangle triangle = GeometryFactory.eINSTANCE.createTriangle();
                Vertex normal = GeometryFactory.eINSTANCE.createVertex();
                normal.setX(buffer.getFloat());
                normal.setY(buffer.getFloat());
                normal.setZ(buffer.getFloat());
                triangle.setNormal(normal);
                int j = 0;
                while (j < 3) {
                    Vertex vertex = GeometryFactory.eINSTANCE.createVertex();
                    vertex.setX(buffer.getFloat());
                    vertex.setY(buffer.getFloat());
                    vertex.setZ(buffer.getFloat());
                    triangle.getVertices().add((Object)vertex);
                    ++j;
                }
                buffer.getShort();
                shape.getTriangles().add((Object)triangle);
                ++i;
            }
        }
        catch (IOException iOException) {}
        return geometry;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFileTypes();
            }
            case 1: {
                return this.getDescription();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getFileTypes().clear();
                this.getFileTypes().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getFileTypes().clear();
                return;
            }
            case 1: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.fileTypes != null && !this.fileTypes.isEmpty();
            }
            case 1: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.load((Path)arguments.get(0));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fileTypes: ");
        result.append(this.fileTypes);
        result.append(", description: ");
        result.append(this.description);
        result.append(')');
        return result.toString();
    }
}

