/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.DiscreteEntry;
import org.eclipse.january.form.IEntryVisitor;

@XmlRootElement(name="ContinuousEntry")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ContinuousEntry
extends DiscreteEntry {
    @XmlTransient
    protected String continuousErrMsg = "'${incorrectValue}' is an unacceptable value. The value must be between ${lowerBound} and ${upperBound}.";

    public ContinuousEntry() {
    }

    public ContinuousEntry(String ... allowed) {
        super(allowed);
        if (allowed.length > 2) {
            throw new IllegalArgumentException("ContinuousEntry must be constructed with exactly 2 allowed values: the lower and upper bound of the range.");
        }
    }

    @Override
    public Object clone() {
        ContinuousEntry entry = new ContinuousEntry();
        entry.copy(this);
        return entry;
    }

    @Override
    public boolean setValue(String newValue) {
        if (this.allowedValues.size() == 2) {
            Double newValueDouble;
            Double lowerBound = Double.valueOf((String)this.allowedValues.get(0));
            Double upperBound = Double.valueOf((String)this.allowedValues.get(1));
            try {
                newValueDouble = Double.valueOf(newValue);
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                String error = this.continuousErrMsg;
                error = error.replace("${incorrectValue}", newValue != null ? newValue : "null");
                error = error.replace("${lowerBound}", this.getAllowedValues().get(0));
                this.errorMessage = error = error.replace("${upperBound}", this.getAllowedValues().get(1));
                return false;
            }
            if (newValueDouble != null && newValueDouble.compareTo(lowerBound) != -1 && newValueDouble.compareTo(upperBound) != 1) {
                this.value = newValue;
                this.errorMessage = null;
                return true;
            }
            String error = this.continuousErrMsg;
            error = error.replace("${incorrectValue}", newValue != null ? newValue : "null");
            error = error.replace("${lowerBound}", this.getAllowedValues().get(0));
            this.errorMessage = error = error.replace("${upperBound}", this.getAllowedValues().get(1));
            return false;
        }
        this.logger.info("ContinuousEntry must be initialized with an allowedValue list of size 2: the lower bound at index 0 and the upper bound at index 1.");
        return false;
    }

    @Override
    public void accept(IEntryVisitor visitor) {
        visitor.visit(this);
    }
}

