/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.BroadcastIteratorBase;
import org.eclipse.january.dataset.BroadcastPairIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.ContiguousPairIterator;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;

public abstract class BroadcastIterator
extends BroadcastIteratorBase {
    public int oIndex;
    public double aDouble;
    public long aLong;
    protected Dataset oDataset;
    protected final boolean outputA;
    protected final boolean outputB;

    public static BroadcastIterator createIterator(Dataset a, Dataset b) {
        return BroadcastIterator.createIterator(a, b, null, false);
    }

    public static BroadcastIterator createIterator(Dataset a, Dataset b, Dataset o) {
        return BroadcastIterator.createIterator(a, b, o, false);
    }

    public static BroadcastIterator createIterator(Dataset a, Dataset b, Dataset o, boolean createIfNull) {
        if (Arrays.equals(a.getShapeRef(), b.getShapeRef()) && a.getStrides() == null && b.getStrides() == null && (o == null || o.getStrides() == null && Arrays.equals(a.getShapeRef(), o.getShapeRef()))) {
            return new ContiguousPairIterator(a, b, o, createIfNull);
        }
        return new BroadcastPairIterator(a, b, o, createIfNull);
    }

    protected BroadcastIterator(Dataset a, Dataset b, Dataset o) {
        super(a, b);
        this.oDataset = o;
        this.outputA = a == o;
        this.outputB = b == o;
        this.read = DTypeUtils.isDTypeNumerical(a.getDType()) && DTypeUtils.isDTypeNumerical(b.getDType());
        this.asDouble = this.aDataset.hasFloatingPointElements() || this.bDataset.hasFloatingPointElements();
        BroadcastUtils.checkItemSize(a, b, o);
    }

    public Dataset getOutput() {
        return this.oDataset;
    }

    @Override
    protected void storeCurrentValues() {
        if (this.aIndex >= 0) {
            if (this.asDouble) {
                this.aDouble = this.aDataset.getElementDoubleAbs(this.aIndex);
            } else {
                this.aLong = this.aDataset.getElementLongAbs(this.aIndex);
            }
        }
        if (this.bIndex >= 0) {
            if (this.asDouble) {
                this.bDouble = this.bDataset.getElementDoubleAbs(this.bIndex);
            } else {
                this.bLong = this.bDataset.getElementLongAbs(this.bIndex);
            }
        }
    }
}

