/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegersIteratorTest {
    Dataset a;
    Dataset b;

    @Before
    public void setUpClass() {
        this.a = DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0});
        this.b = DatasetFactory.createFromObject((Object)new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0});
    }

    @Test
    public void testShapes() {
        IntegerDataset s = (IntegerDataset)DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{2, 3, 4});
        IntegerDataset t = (IntegerDataset)DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{2, 3, 4});
        IntegerDataset u = (IntegerDataset)DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{2, 3, 4});
        IntegerDataset v = (IntegerDataset)DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{1});
        int[] shape = new int[]{10, 20, 30};
        IntegersIterator iter = new IntegersIterator(shape, new Object[0]);
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{10, 20, 30}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, t, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{null, t, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{10, 2, 3, 4}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, null, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 20}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, t, null});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 30}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2)), t, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{3, 2, 3, 4}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2)), u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 3}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, t, new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2))});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 3}, (int[])iter.getShape());
        shape = new int[]{10, 20, 30, 40, 50};
        iter = new IntegersIterator(shape, new Object[]{s, t, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{null, t, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{10, 2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, null, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 20, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, t, null});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 30, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2)), t, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{3, 2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2)), u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 3, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, t, new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2))});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 3, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, t, new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2))});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 3, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, t, v});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, v, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{v, t, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{s, v, v});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{v, t, v});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 40, 50}, (int[])iter.getShape());
        iter = new IntegersIterator(shape, new Object[]{v, v, u});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{2, 3, 4, 40, 50}, (int[])iter.getShape());
        shape = new int[]{10, 20, 30};
        s = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{2, 5, 9}, null);
        int[] nArray = new int[6];
        nArray[1] = 5;
        nArray[2] = 10;
        nArray[3] = 15;
        nArray[4] = 18;
        nArray[5] = 19;
        t = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray, null);
        iter = new IntegersIterator(true, shape, new Object[]{s, t, new Slice(Integer.valueOf(1), Integer.valueOf(7), Integer.valueOf(2))});
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{3, 6, 3}, (int[])iter.getShape());
    }

    @Test
    public void testEqualTo() {
        Dataset c = this.a.clone().reshape(new int[]{2, 3});
        int[] nArray = new int[3];
        nArray[1] = 1;
        IntegerDataset s = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray, null);
        int[] nArray2 = new int[3];
        nArray2[1] = 2;
        nArray2[2] = 1;
        IntegerDataset t = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray2, null);
        ArrayList<Double> inds = new ArrayList<Double>();
        IntegersIterator iter = new IntegersIterator(c.getShapeRef(), new Object[0]);
        int[] pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)this.a, (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, -9.0, 1.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, null});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{null, t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 3.0, 1.0, 5.0, -9.0, -7.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, new Slice()});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{new Slice(), t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 3.0, 1.0, 5.0, -9.0, -7.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, new Slice(Integer.valueOf(1))});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 5.0, 0.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{new Slice(Integer.valueOf(1)), t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 3.0, 1.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        t = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray3, null);
        iter = new IntegersIterator(true, c.getShapeRef(), new Object[]{s, t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 3.0, 5.0, -9.0, 0.0, 3.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        int[] nArray4 = new int[12];
        nArray4[1] = 1;
        nArray4[4] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[8] = 1;
        s = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray4, (int[])new int[]{2, 3, 2});
        int[] nArray5 = new int[12];
        nArray5[0] = 2;
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[4] = 1;
        nArray5[5] = 2;
        nArray5[6] = 1;
        nArray5[10] = 1;
        t = (IntegerDataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray5, (int[])new int[]{2, 3, 2});
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, -7.0, 1.0, 0.0, -7.0, 3.0, -7.0, 5.0, 5.0, 0.0, 1.0, 0.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, null});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0, 0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 5.0, -7.0, -9.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0, 0.0, 1.0, 3.0, 0.0, 1.0, 3.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{null, t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, 1.0, 1.0, 0.0, 1.0, 3.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, -9.0, -7.0, -7.0, 5.0, -7.0, -9.0, -7.0, 5.0, 5.0, 5.0, -7.0, 5.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, new Slice()});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0, 0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0, 5.0, -7.0, -9.0, 5.0, -7.0, -9.0, 5.0, -7.0, -9.0, 0.0, 1.0, 3.0, 0.0, 1.0, 3.0, 0.0, 1.0, 3.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{new Slice(), t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, 1.0, 1.0, 0.0, 1.0, 3.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, -9.0, -7.0, -7.0, 5.0, -7.0, -9.0, -7.0, 5.0, 5.0, 5.0, -7.0, 5.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, new Slice(Integer.valueOf(1))});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{0.0, 5.0, 0.0, 0.0, 5.0, 0.0, 5.0, 5.0, 5.0, 0.0, 0.0, 0.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{new Slice(Integer.valueOf(1)), t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{3.0, 1.0, 1.0, 0.0, 1.0, 3.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{s, new Slice(Integer.valueOf(1), null, Integer.valueOf(-1))});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{1.0, 0.0, -7.0, 5.0, 1.0, 0.0, 1.0, 0.0, -7.0, 5.0, 1.0, 0.0, -7.0, 5.0, -7.0, 5.0, -7.0, 5.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{new Slice(Integer.valueOf(1), null, Integer.valueOf(-1)), t});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{-9.0, -7.0, -7.0, 5.0, -7.0, -9.0, -7.0, 5.0, 5.0, 5.0, -7.0, 5.0, 3.0, 1.0, 1.0, 0.0, 1.0, 3.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{new Slice(null, null, Integer.valueOf(-1))});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{5.0, -7.0, -9.0, 0.0, 1.0, 3.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
        iter = new IntegersIterator(c.getShapeRef(), new Object[]{null, new Slice(Integer.valueOf(1), null, Integer.valueOf(-1))});
        pos = iter.getPos();
        while (iter.hasNext()) {
            inds.add(c.getDouble(pos));
        }
        this.checkDatasets((DoubleDataset)DatasetFactory.createFromObject(DoubleDataset.class, (Object)new double[]{1.0, 0.0, -7.0, 5.0}, (int[])new int[0]), (DoubleDataset)DatasetFactory.createFromList(DoubleDataset.class, inds));
        inds.clear();
    }

    private void checkDatasets(DoubleDataset expected, DoubleDataset calc) {
        TestUtils.assertDatasetEquals((Dataset)expected, (Dataset)calc, (double)0.1, (double)1.0E-5);
    }
}

