/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.BroadcastIteratorBase;
import org.eclipse.january.dataset.BroadcastSingleIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.ContiguousSingleIterator;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;

public abstract class BroadcastSelfIterator
extends BroadcastIteratorBase {
    public static BroadcastSelfIterator createIterator(Dataset a, Dataset b) {
        if (Arrays.equals(a.getShapeRef(), b.getShapeRef()) && a.getStrides() == null && b.getStrides() == null) {
            return new ContiguousSingleIterator(a, b);
        }
        return new BroadcastSingleIterator(a, b);
    }

    protected BroadcastSelfIterator(Dataset a, Dataset b) {
        super(a, b);
        this.read = DTypeUtils.isDTypeNumerical(b.getDType());
        this.asDouble = this.aDataset.hasFloatingPointElements();
        BroadcastUtils.checkItemSize(a, b, null);
    }

    @Override
    protected void storeCurrentValues() {
        if (this.bIndex >= 0) {
            if (this.asDouble) {
                this.bDouble = this.bDataset.getElementDoubleAbs(this.bIndex);
            } else {
                this.bLong = this.bDataset.getElementLongAbs(this.bIndex);
            }
        }
    }
}

