/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    private EditorUtility() {
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }

    public static ITypeRoot getJavaInput(IEditorPart part) {
        IJavaElement input;
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput != null && (input = JavaUI.getEditorInputJavaElement((IEditorInput)editorInput)) instanceof ITypeRoot) {
            return (ITypeRoot)input;
        }
        return null;
    }

    public static void selectInEditor(ITextEditor editor, int offset, int length) {
        IEditorPart active = EditorUtility.getActiveEditor();
        if (active != editor) {
            editor.getSite().getPage().activate((IWorkbenchPart)editor);
        }
        editor.selectAndReveal(offset, length);
    }
}

